/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.MapObjectWalker;
import com.agateau.pixelwheels.map.PolylineMapObjectWalker;
import com.agateau.pixelwheels.map.RectangleMapObjectWalker;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;

public class MapObjectWalkerFactory {
    private static final RectangleMapObjectWalker sRectangleWalker = new RectangleMapObjectWalker();
    private static final PolylineMapObjectWalker sPolylineWalker = new PolylineMapObjectWalker();

    public static MapObjectWalker get(MapObject object) {
        MapObjectWalker walker;
        if (object instanceof RectangleMapObject) {
            walker = sRectangleWalker;
        } else if (object instanceof PolylineMapObject) {
            walker = sPolylineWalker;
        } else {
            throw new RuntimeException("Unsupported MapObject type: " + object);
        }
        walker.setMapObject(object);
        return walker;
    }
}

