/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.LapPosition;
import com.agateau.pixelwheels.map.LapPositionTable;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.agateau.utils.AgcMathUtils;
import com.agateau.utils.Assert;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class WaypointStore {
    private static final OrientedPoint tmpPoint = new OrientedPoint();
    private final Array<WaypointInfo> mWaypointInfos = new Array();

    public void read(MapLayer layer, LapPositionTable lapPositionTable) {
        float U = 0.05f;
        Assert.check(layer.getObjects().getCount() == 1, "Waypoints layer should contain 1 and only 1 object", new Object[0]);
        PolylineMapObject polylineMapObject = (PolylineMapObject)layer.getObjects().get(0);
        float[] vertices = polylineMapObject.getPolyline().getTransformedVertices();
        int count = vertices.length / 2;
        for (int idx = 0; idx < count; ++idx) {
            int x = (int)vertices[2 * idx];
            int y = (int)vertices[2 * idx + 1];
            LapPosition pos = lapPositionTable.get(x, y);
            Assert.check(pos != null, "No position at " + x + "x" + y, new Object[0]);
            WaypointInfo info = new WaypointInfo();
            info.waypoint.set(x, y).scl(0.05f);
            info.lapDistance = pos.getLapDistance();
            if (idx > 0) {
                Assert.check(info.lapDistance > this.mWaypointInfos.get((int)(idx - 1)).lapDistance, "Lap distance for point " + idx + " is shorter than for point " + (idx - 1), new Object[0]);
            }
            this.mWaypointInfos.add(info);
        }
    }

    public Vector2 getWaypoint(int index) {
        return this.mWaypointInfos.get((int)index).waypoint;
    }

    public int getPreviousIndex(int index) {
        return (index > 0 ? index : this.mWaypointInfos.size) - 1;
    }

    public int getNextIndex(int index) {
        return (index + 1) % this.mWaypointInfos.size;
    }

    public int getCount() {
        return this.mWaypointInfos.size;
    }

    public OrientedPoint getValidPosition(Vector2 pos, float lapDistance) {
        int nextIdx = this.getWaypointIndex(lapDistance);
        int prevIdx = this.getPreviousIndex(nextIdx);
        Vector2 prev = this.mWaypointInfos.get((int)prevIdx).waypoint;
        Vector2 next = this.mWaypointInfos.get((int)nextIdx).waypoint;
        Vector2 projected = AgcMathUtils.project(pos, prev, next);
        float waypointSquareLength = prev.dst2(next);
        if (projected.dst2(prev) > waypointSquareLength) {
            projected.set(next);
        } else if (projected.dst2(next) > waypointSquareLength) {
            projected.set(prev);
        }
        WaypointStore.tmpPoint.x = projected.x;
        WaypointStore.tmpPoint.y = projected.y;
        WaypointStore.tmpPoint.angle = AgcMathUtils.normalizeAngle(AgcMathUtils.segmentAngle(prev, next));
        return tmpPoint;
    }

    public int getWaypointIndex(float lapDistance) {
        for (int idx = 0; idx < this.mWaypointInfos.size; ++idx) {
            if (!(lapDistance < this.mWaypointInfos.get((int)idx).lapDistance)) continue;
            return idx;
        }
        return 0;
    }

    private static class WaypointInfo {
        final Vector2 waypoint = new Vector2();
        float lapDistance;

        private WaypointInfo() {
        }
    }
}

