/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.agateau.utils.CircularArray;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.Disposable;

public class Wheel
implements Disposable {
    private static final float DRIFT_IMPULSE_REDUCTION = 0.5f;
    private static final float DRAG_FACTOR = 1.0f;
    private static final int SKIDMARK_INTERVAL = 3;
    private static final float SKIDMARK_LIFETIME = 10.0f;
    private final CircularArray<Skidmark> mSkidmarks;
    private int mSkidmarkCount;
    private final Body mBody;
    private final GameWorld mGameWorld;
    private final TextureRegion mRegion;
    private final Animation<TextureRegion> mSplashAnimation;
    private final Vehicle mVehicle;
    private boolean mCanDrift;
    private float mMaxDrivingForce;
    private Material mMaterial;
    private boolean mDrifting;

    public Wheel(GameWorld gameWorld, Vehicle vehicle, TextureRegion region, Animation<TextureRegion> splashAnimation, float density, float posX, float posY, float angle) {
        this.mSkidmarks = new CircularArray<Skidmark>(Debug.instance.maxSkidmarks){

            @Override
            protected Skidmark createInstance() {
                return new Skidmark();
            }
        };
        this.mSkidmarkCount = 0;
        this.mCanDrift = false;
        this.mMaterial = Material.ROAD;
        this.mDrifting = false;
        this.mGameWorld = gameWorld;
        this.mVehicle = vehicle;
        this.mRegion = region;
        this.mSplashAnimation = splashAnimation;
        float w = 0.05f * (float)region.getRegionWidth();
        float h = 0.05f * (float)region.getRegionHeight();
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.position.set(posX, posY);
        bodyDef.angle = angle * ((float)Math.PI / 180);
        this.mBody = this.mGameWorld.getBox2DWorld().createBody(bodyDef);
        PolygonShape shape = new PolygonShape();
        shape.set(Box2DUtils.createOctogon(w, h, w / 4.0f, w / 4.0f));
        this.mBody.createFixture(shape, density);
        shape.dispose();
    }

    public TextureRegion getRegion() {
        return this.mRegion;
    }

    public Animation<TextureRegion> getSplashAnimation() {
        return this.mSplashAnimation;
    }

    public boolean isDrifting() {
        return this.mDrifting;
    }

    @Override
    public void dispose() {
        this.mGameWorld.getBox2DWorld().destroyBody(this.mBody);
    }

    public void act(float delta) {
        this.updateGroundInfo();
        if (!this.mVehicle.isFlying()) {
            this.updateFriction();
            Box2DUtils.applyDrag(this.mBody, 1.0f);
        }
        int idx = this.mSkidmarks.getBeginIndex();
        int end = this.mSkidmarks.getEndIndex();
        while (idx != end) {
            this.mSkidmarks.get(idx).act(delta);
            idx = this.mSkidmarks.getNextIndex(idx);
        }
    }

    public Body getBody() {
        return this.mBody;
    }

    public float getGroundSpeed() {
        return this.mMaterial.getSpeed();
    }

    public void adjustSpeed(float amount) {
        if (amount == 0.0f) {
            return;
        }
        float currentSpeed = this.mBody.getLinearVelocity().len() * 3.6f;
        float limit = 1.0f - 0.2f * Interpolation.sineOut.apply(currentSpeed / (float)GamePlay.instance.maxSpeed);
        float force = this.mMaxDrivingForce * (amount *= limit);
        float angle = this.mBody.getAngle();
        Vector2 pos = this.mBody.getWorldCenter();
        this.mBody.applyForce(force * MathUtils.cos(angle), force * MathUtils.sin(angle), pos.x, pos.y, true);
    }

    public long getCellId() {
        return this.mGameWorld.getTrack().getCellIdAt(this.mBody.getWorldCenter().x, this.mBody.getWorldCenter().y);
    }

    private void updateFriction() {
        Vector2 impulse = Box2DUtils.getLateralVelocity(this.mBody).scl(-this.mBody.getMass()).scl(this.mMaterial.getGrip());
        float maxImpulse = (float)GamePlay.instance.maxLateralImpulse / (this.mVehicle.isBraking() ? 0.2f : 1.0f);
        if (this.mMaterial != Material.ICE && !this.mMaterial.isWater() && this.mCanDrift && impulse.len() > maxImpulse) {
            this.mDrifting = true;
            if (this.mSkidmarkCount == 0) {
                this.mSkidmarks.add().init(this.mBody.getWorldCenter());
            }
            this.mSkidmarkCount = (this.mSkidmarkCount + 1) % 3;
            maxImpulse = Math.max(maxImpulse, impulse.len() - 0.5f);
            impulse.limit(maxImpulse);
        } else if (this.mDrifting) {
            this.mSkidmarks.add().initAsEndIndicator();
            this.mDrifting = false;
        }
        this.mBody.applyLinearImpulse(impulse, this.mBody.getWorldCenter(), true);
        this.mBody.applyAngularImpulse(0.1f * this.mBody.getInertia() * -this.mBody.getAngularVelocity(), true);
    }

    private void updateGroundInfo() {
        if (this.mVehicle.isFlying()) {
            this.mMaterial = Material.AIR;
            return;
        }
        this.mMaterial = this.mGameWorld.getTrack().getMaterialAt(this.mBody.getWorldCenter());
    }

    public void setCanDrift(boolean canDrift) {
        this.mCanDrift = canDrift;
    }

    public void setMaxDrivingForce(float maxDrivingForce) {
        this.mMaxDrivingForce = maxDrivingForce;
    }

    public CircularArray<Skidmark> getSkidmarks() {
        return this.mSkidmarks;
    }

    public Material getMaterial() {
        return this.mMaterial;
    }

    public static class Skidmark {
        private final Vector2 mPos = new Vector2();
        private final Vector2 mThickness = new Vector2();
        private boolean mIsEndIndicator = false;
        private float mRemainingLife;

        public boolean isEndIndicator() {
            return this.mIsEndIndicator;
        }

        public Vector2 getPos() {
            return this.mPos;
        }

        public void init(Vector2 pos) {
            this.mPos.set(pos);
            this.mThickness.set(0.0f, 0.0f);
            this.mRemainingLife = 10.0f;
        }

        public void initAsEndIndicator() {
            this.mIsEndIndicator = true;
        }

        public boolean hasThickness() {
            return this.mThickness.x != 0.0f && this.mThickness.y != 0.0f;
        }

        public void setThickness(Vector2 thickness) {
            this.mThickness.set(thickness);
        }

        public Vector2 getThickness() {
            return this.mThickness;
        }

        public void act(float delta) {
            this.mRemainingLife = Math.max(0.0f, this.mRemainingLife - delta);
        }

        public float getOpacity() {
            return this.mRemainingLife / 10.0f;
        }

        public boolean isFinished() {
            return this.mRemainingLife <= 0.0f;
        }
    }
}

