/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.racescreen.CameraUpdater;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;

class FreeCameraUpdater
extends CameraUpdater {
    private static final float MIN_ZOOM = 0.1f;
    private static final float MAX_ZOOM = 10.0f;
    private static final float UNITS_PER_SECOND = 20.0f;
    private static final float ZOOM_PER_SECOND = 5.0f;
    private static final float SHIFT_FACTOR = 10.0f;

    FreeCameraUpdater(GameWorld world) {
        super(world);
    }

    @Override
    public void update(float delta) {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        if (Gdx.input.isKeyPressed(36)) {
            dx = -20.0f * delta;
        } else if (Gdx.input.isKeyPressed(40)) {
            dx = 20.0f * delta;
        }
        if (Gdx.input.isKeyPressed(38)) {
            dy = -20.0f * delta;
        } else if (Gdx.input.isKeyPressed(39)) {
            dy = 20.0f * delta;
        }
        if (FreeCameraUpdater.isKeyPressed(69, 13)) {
            dz = 5.0f * delta;
        } else if (FreeCameraUpdater.isKeyPressed(81, 70)) {
            dz -= 5.0f * delta;
        }
        if (FreeCameraUpdater.isKeyPressed(59, 60)) {
            dx *= 10.0f;
            dy *= 10.0f;
            dz *= 10.0f;
        }
        this.mNextCameraInfo.zoom = MathUtils.clamp(this.mCameraInfo.zoom + dz, 0.1f, 10.0f);
        float viewportWidth = (float)GamePlay.instance.viewportWidth * this.mNextCameraInfo.zoom;
        float viewportHeight = viewportWidth * (float)this.mScreenHeight / (float)this.mScreenWidth;
        this.mNextCameraInfo.viewportWidth = viewportWidth;
        this.mNextCameraInfo.viewportHeight = viewportHeight;
        this.mNextCameraInfo.position.x = this.mCameraInfo.position.x + dx;
        this.mNextCameraInfo.position.y = this.mCameraInfo.position.y + dy;
        this.mNextCameraInfo.clampPositionToTrack(this.mWorld.getTrack());
        this.applyChanges();
    }

    private static boolean isKeyPressed(int k1, int k2) {
        return Gdx.input.isKeyPressed(k1) || Gdx.input.isKeyPressed(k2);
    }
}

