/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.racescreen.HudButton;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.utils.PlatformUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;

public class Hud {
    private static final float BUTTON_SIZE_INCH = 1.1811024f;
    private static final float DIP_DPI = 160.0f;
    private final float BUTTON_SIZE_PX;
    private final AnchorGroup mRoot;
    private final PwGame mGame;
    private AnchorGroup mInputUiContainer;
    private float mZoom;
    private HudButton mPauseButton;

    public Hud(PwGame game, Stage stage) {
        this.mGame = game;
        this.mRoot = new AnchorGroup();
        this.BUTTON_SIZE_PX = game.getAssets().findRegion("hud-pie-right").getRegionWidth();
        stage.addActor(this.mRoot);
    }

    public AnchorGroup getRoot() {
        return this.mRoot;
    }

    public void deleteInputUiContainer() {
        if (this.mInputUiContainer == null) {
            return;
        }
        this.mInputUiContainer.remove();
        this.mInputUiContainer = null;
    }

    public AnchorGroup getInputUiContainer() {
        if (this.mInputUiContainer == null) {
            this.mInputUiContainer = new AnchorGroup();
            this.mInputUiContainer.setTouchable(Touchable.childrenOnly);
            this.mRoot.addActor(this.mInputUiContainer);
            this.mInputUiContainer.setFillParent(true);
        }
        return this.mInputUiContainer;
    }

    public void setScreenRect(int x, int y, int width, int height) {
        this.mRoot.setBounds(x, y, width, height);
        this.updateZoom();
    }

    public float getInputUiWidth() {
        return this.mRoot.getWidth();
    }

    public float getInputUiHeight() {
        float pauseButtonHeight = this.mPauseButton == null ? 0.0f : this.mPauseButton.getHeight();
        return this.mRoot.getHeight() - pauseButtonHeight;
    }

    public float getZoom() {
        float zoom = this.mGame.getConfig().hudZoom;
        if (zoom != 0.0f) {
            return zoom;
        }
        return this.mZoom;
    }

    private void updateZoom() {
        if (PlatformUtils.isDesktop()) {
            this.mZoom = 1.0f;
            return;
        }
        float pxSize = 188.97638f * Gdx.graphics.getDensity();
        float upp = PwStageScreen.getUnitsPerPixel();
        this.mZoom = Math.max(pxSize / this.BUTTON_SIZE_PX * upp, 1.0f);
    }

    public void addPauseButton(HudButton button) {
        this.mPauseButton = button;
        this.mRoot.addPositionRule(button, Anchor.TOP_LEFT, this.mRoot, Anchor.TOP_LEFT);
    }
}

