/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gamesetup.ChampionshipGameInfo;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.screens.NavStageScreen;
import com.agateau.pixelwheels.screens.ScrollableTiledImage;
import com.agateau.pixelwheels.screens.VehicleActor;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.TableRowCreator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import java.util.Locale;

public class ChampionshipFinishedScreen
extends NavStageScreen {
    private final PwGame mGame;
    private final ChampionshipGameInfo mGameInfo;
    private final TableRowCreator mTableRowCreator = new TableRowCreator(4){

        @Override
        protected Cell<Label> createCell(Table table, int column, String value, String style) {
            Cell<Label> cell = table.add(value, style);
            if (column == 1) {
                cell.left().expandX();
            } else {
                cell.right();
            }
            return cell;
        }
    };
    private final NavStageScreen.NextListener mNextListener;

    public ChampionshipFinishedScreen(PwGame game, ChampionshipGameInfo gameInfo, NavStageScreen.NextListener nextListener) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mGameInfo = gameInfo;
        this.mNextListener = nextListener;
        if (this.isPlayerOnPodium()) {
            this.setupPodiumUi();
        } else {
            this.setupNoPodiumUi();
        }
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                ChampionshipFinishedScreen.this.mGame.replaceScreen(new ChampionshipFinishedScreen(ChampionshipFinishedScreen.this.mGame, ChampionshipFinishedScreen.this.mGameInfo, ChampionshipFinishedScreen.this.mNextListener));
            }
        };
    }

    private boolean isPlayerOnPodium() {
        for (int idx = 0; idx < Math.min(3, this.mGameInfo.getEntrants().size); ++idx) {
            GameInfo.Entrant entrant = this.mGameInfo.getEntrants().get(idx);
            if (!entrant.isPlayer()) continue;
            return true;
        }
        return false;
    }

    private void setupPodiumUi() {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = new UiBuilder(assets.ui.atlas, assets.ui.skin);
        VehicleActor.register(builder, assets);
        builder.registerActorFactory("Road", (uiBuilder, element) -> {
            float pixelsPerSecond = element.getFloatAttribute("pixelsPerSecond", 0.0f);
            return new ScrollableTiledImage(assets.ui.atlas.findRegion("road"), pixelsPerSecond);
        });
        builder.registerActorFactory("Shadow", (uiBuilder, element) -> {
            String sourceId = element.getAttribute("source", null);
            if (sourceId == null) {
                throw new UiBuilder.SyntaxException("Missing 'source' attribute");
            }
            Image source = (Image)uiBuilder.getActor(sourceId);
            float offset = element.getFloatAttribute("offset", 12.0f);
            return new ShadowActor(source, offset);
        });
        this.mTableRowCreator.setSpacing(12);
        if (!this.setupCommonUi(builder, FileUtils.assets("screens/championshipfinished-podium.gdxui"))) {
            return;
        }
        this.fillPodium(builder, this.mGameInfo.getEntrants());
        this.mGame.getAudioManager().playMusic("victory");
    }

    private void setupNoPodiumUi() {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = new UiBuilder(assets.ui.atlas, assets.ui.skin);
        this.setupCommonUi(builder, FileUtils.assets("screens/championshipfinished-nopodium.gdxui"));
    }

    private boolean setupCommonUi(UiBuilder builder, FileHandle uiFileHandle) {
        AnchorGroup root = (AnchorGroup)builder.build(uiFileHandle);
        if (root == null) {
            NLog.e("Failed to create ui", new Object[0]);
            return false;
        }
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.setupMainLabels(builder);
        this.setupChampionshipIcon(builder);
        this.setupNextButton((Button)builder.getActor("nextButton"));
        this.setNavListener(this.mNextListener);
        Table table = (Table)builder.getActor("entrantTable");
        float spacing = builder.getFloatConfigValue("entrantTableSpacing");
        this.mTableRowCreator.setSpacing((int)spacing);
        this.fillEntrantTable(table, this.mGameInfo.getEntrants());
        return true;
    }

    private void setupChampionshipIcon(UiBuilder builder) {
        Image image = (Image)builder.getActor("championshipIcon");
        TextureRegion region = this.mGame.getAssets().getChampionshipRegion(this.mGameInfo.getChampionship());
        image.setDrawable(new TextureRegionDrawable(region));
        image.pack();
    }

    private void setupMainLabels(UiBuilder builder) {
        String label2;
        String label1;
        String text = Translator.trc("Championship\nFinished!", "Must be two sentences separated by a newline");
        int idx = text.indexOf(10);
        if (idx == -1) {
            NLog.e("Translation error: '%s' does not contain a newline character!", new Object[0]);
            label1 = text;
            label2 = "";
        } else {
            label1 = text.substring(0, idx);
            label2 = text.substring(idx + 1);
        }
        ((Label)builder.getActor("mainLabel1")).setText(label1);
        ((Label)builder.getActor("mainLabel2")).setText(label2);
    }

    private void fillEntrantTable(Table table, Array<GameInfo.Entrant> entrants) {
        this.mTableRowCreator.setTable(table);
        this.mTableRowCreator.addHeaderRow(Translator.tr("#"), Translator.tr("Racer"), Translator.tr("Total time"), Translator.tr("Points"));
        for (int idx = 0; idx < entrants.size; ++idx) {
            GameInfo.Entrant entrant = entrants.get(idx);
            VehicleDef vehicleDef = this.mGame.getAssets().findVehicleDefById(entrant.getVehicleId());
            String style = UiUtils.getEntrantRowStyle(entrant);
            String totalTime = StringUtils.formatRaceTime(entrant.getRaceTime());
            this.mTableRowCreator.setRowStyle(style);
            this.mTableRowCreator.addRow(String.format(Locale.US, "%d.", idx + 1), vehicleDef.getName(), totalTime, String.valueOf(entrant.getPoints()));
        }
    }

    private void fillPodium(UiBuilder builder, Array<GameInfo.Entrant> entrants) {
        Assets assets = this.mGame.getAssets();
        for (int idx = 0; idx < Math.min(3, entrants.size); ++idx) {
            GameInfo.Entrant entrant = entrants.get(idx);
            VehicleDef vehicleDef = assets.findVehicleDefById(entrant.getVehicleId());
            VehicleActor actor = (VehicleActor)builder.getActor("vehicle" + idx);
            actor.setVehicleDef(vehicleDef);
        }
    }

    private static class ShadowActor
    extends Actor {
        private final Image mSource;
        private final float mOffset;

        ShadowActor(Image source, float offset) {
            this.mSource = source;
            this.mOffset = offset;
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            this.mSource.setZIndex(this.getZIndex() + 1);
            this.setX(this.mSource.getX() + this.mOffset);
            this.setY(this.mSource.getY() - this.mOffset);
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            batch.setColor(0.0f, 0.0f, 0.0f, 0.35f);
            this.mSource.getDrawable().draw(batch, this.getX(), this.getY(), this.mSource.getWidth(), this.mSource.getHeight());
        }
    }
}

