/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.translations.Translator;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.SliderMenuItem;
import com.agateau.ui.uibuilder.UiBuilder;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

class DifficultySelectorController {
    DifficultySelectorController() {
    }

    public static void registerFactory(UiBuilder builder, GameConfig config) {
        builder.registerMenuItemFactory("DifficultySelector", (menu, element) -> {
            if (element.getBoolean("header", true)) {
                menu.addLabel(Translator.tr("League"));
            }
            return DifficultySelectorController.create(menu, config);
        });
    }

    private static SliderMenuItem create(Menu menu, final GameConfig config) {
        final SliderMenuItem selector = new SliderMenuItem(menu){

            @Override
            protected String formatValue(int value) {
                Difficulty difficulty = DifficultySelectorController.difficultyForInt(value);
                return difficulty.toTranslatedString();
            }
        };
        menu.addItem(selector);
        selector.setRange(0, Difficulty.values().length - 1);
        selector.setIntValue(config.difficulty.ordinal());
        selector.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                config.difficulty = DifficultySelectorController.difficultyForInt(selector.getIntValue());
                config.flush(GameConfig.ConfigGroup.OTHER);
            }
        });
        return selector;
    }

    private static Difficulty difficultyForInt(int value) {
        return Difficulty.values()[value];
    }
}

