/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens.config;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.gameinput.GamepadInputHandler;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.config.ConfigUiUtils;
import com.agateau.translations.Translator;
import com.agateau.ui.GamepadInputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import java.util.Locale;

public class GamepadConfigScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final int mPlayerIdx;
    private final GamepadInputMapper mInputMapper;
    private final Array<GamepadButtonItemController> mButtonControllers = new Array();
    private GamepadButtonItemController mEditingController;

    GamepadConfigScreen(PwGame game, int playerIdx) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mPlayerIdx = playerIdx;
        GamepadInputHandler handler = (GamepadInputHandler)this.mGame.getConfig().getPlayerInputHandler(this.mPlayerIdx);
        this.mInputMapper = (GamepadInputMapper)handler.getInputMapper();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                GamepadConfigScreen.this.mGame.replaceScreen(new GamepadConfigScreen(GamepadConfigScreen.this.mGame, GamepadConfigScreen.this.mPlayerIdx));
            }
        };
        this.setupUi();
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        builder.registerMenuItemFactory("KeyMenuItem", (menu, element) -> {
            String label1 = Translator.tr(element.getAttribute("label1", ""));
            String label2 = Translator.tr(element.getAttribute("label2", ""));
            String keyStr = element.getAttribute("key", "");
            if (keyStr.equals("")) {
                return ConfigUiUtils.createTwoColumnTitle(menu, label1, label2);
            }
            VirtualKey key = VirtualKey.valueOf(keyStr);
            return this.createButton(menu, label1, label2, key);
        });
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/gamepadconfig.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        Menu menu2 = (Menu)builder.getActor("menu");
        menu2.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                GamepadConfigScreen.this.onBackPressed();
            }
        });
    }

    private MenuItem createButton(Menu menu, String text1, String text2, VirtualKey virtualKey) {
        ButtonMenuItem buttonItem = new ButtonMenuItem(menu, "");
        ConfigUiUtils.createTwoColumnRow(menu, text1, text2, buttonItem);
        GamepadButtonItemController controller = new GamepadButtonItemController(buttonItem, virtualKey);
        this.mButtonControllers.add(controller);
        return buttonItem;
    }

    private void startEditing(GamepadButtonItemController controller) {
        this.stopEditing();
        this.mEditingController = controller;
        this.mEditingController.setEditing(true);
        this.mInputMapper.setListener(this.mEditingController);
    }

    private void stopEditing() {
        if (this.mEditingController != null) {
            this.mEditingController.setEditing(false);
            this.mInputMapper.setListener(null);
        }
    }

    @Override
    public void onBackPressed() {
        this.stopEditing();
        this.saveConfig();
        this.mGame.popScreen();
    }

    private void saveConfig() {
        GameConfig config = this.mGame.getConfig();
        config.savePlayerInputHandlerConfig(this.mPlayerIdx);
    }

    private class GamepadButtonItemController
    implements GamepadInputMapper.Listener {
        private final ButtonMenuItem mMenuItem;
        private final VirtualKey mVirtualKey;
        private boolean mEditing = false;

        GamepadButtonItemController(ButtonMenuItem menuItem, VirtualKey virtualKey) {
            this.mMenuItem = menuItem;
            this.mVirtualKey = virtualKey;
            this.mMenuItem.addListener(new MenuItemListener(){

                @Override
                public void triggered() {
                    GamepadConfigScreen.this.startEditing(GamepadButtonItemController.this);
                }
            });
            this.updateText();
        }

        void setEditing(boolean editing) {
            this.mEditing = editing;
            this.updateText();
        }

        private void updateText() {
            String text = this.mEditing ? "..." : String.format(Locale.US, "%d", GamepadConfigScreen.this.mInputMapper.getButtonCodeForVirtualKey(this.mVirtualKey));
            this.mMenuItem.setText(text);
        }

        @Override
        public boolean onButtonPressed(int buttonCode, boolean pressed) {
            GamepadConfigScreen.this.mInputMapper.setButtonCodeForVirtualKey(this.mVirtualKey, buttonCode);
            GamepadConfigScreen.this.stopEditing();
            return true;
        }
    }
}

