/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens.config;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactories;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.gameinput.GamepadInputHandler;
import com.agateau.pixelwheels.gameinput.KeyboardInputHandler;
import com.agateau.pixelwheels.screens.config.GameInputHandlerConfigScreenFactory;
import com.agateau.pixelwheels.screens.config.GamepadConfigScreen;
import com.agateau.pixelwheels.screens.config.KeyboardConfigScreen;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.ui.GamepadInputMappers;
import com.agateau.ui.UiAssets;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.LabelMenuItem;
import com.agateau.ui.menu.MenuItemListener;
import com.agateau.ui.menu.SelectorMenuItem;
import com.agateau.utils.Assert;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;

public class InputSelectorController {
    private final PwGame mGame;
    private final SelectorMenuItem<GameInputHandlerFactory> mSelector;
    private final ButtonMenuItem mConfigureButton;
    private final int mPlayerIdx;
    private final LabelMenuItem mNameLabel;

    public InputSelectorController(PwGame game, SelectorMenuItem<GameInputHandlerFactory> selector, ButtonMenuItem configureButton, LabelMenuItem nameLabel, int idx) {
        this.mGame = game;
        this.mSelector = selector;
        this.mConfigureButton = configureButton;
        this.mNameLabel = nameLabel;
        this.mPlayerIdx = idx;
        UiAssets uiAssets = this.mGame.getAssets().ui;
        Array<GameInputHandlerFactory> inputFactories = GameInputHandlerFactories.getAvailableFactories();
        for (GameInputHandlerFactory factory : inputFactories) {
            String iconName = "input-icons/" + factory.getId();
            TextureRegionDrawable drawable = new TextureRegionDrawable(uiAssets.atlas.findRegion(iconName));
            selector.addEntry(drawable, factory.getName(), factory);
        }
        selector.getActor().addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                InputSelectorController.this.onInputChanged();
            }
        });
        configureButton.addListener(new MenuItemListener(){

            @Override
            public void triggered() {
                InputSelectorController.this.onConfigureClicked();
            }
        });
        GamepadInputMappers.getInstance().addListener(new GamepadInputMappers.Listener(){

            @Override
            public void onGamepadConnected() {
                InputSelectorController.this.updateUi();
            }

            @Override
            public void onGamepadDisconnected() {
                InputSelectorController.this.updateUi();
            }
        });
    }

    private void onInputChanged() {
        GameInputHandlerFactory factory = this.mSelector.getCurrentData();
        this.mGame.getConfig().setPlayerInputHandlerFactory(this.mPlayerIdx, factory);
        this.mGame.getConfig().flush(GameConfig.ConfigGroup.INPUT);
        this.updateUi();
    }

    private void onConfigureClicked() {
        GameInputHandlerFactory factory = this.mSelector.getCurrentData();
        GameInputHandlerConfigScreenFactory configScreenFactory = InputSelectorController.getInputConfigScreenFactory(factory);
        Assert.check(configScreenFactory != null, "No config screen for this game factory", new Object[0]);
        this.mGame.pushScreen(configScreenFactory.createScreen(this.mGame, this.mPlayerIdx));
    }

    public void setStartupState() {
        GameInputHandlerFactory factory = this.mGame.getConfig().getPlayerInputHandlerFactory(this.mPlayerIdx);
        this.mSelector.setCurrentData(factory);
        this.updateUi();
    }

    private void updateUi() {
        GameInputHandlerFactory factory = this.mSelector.getCurrentData();
        boolean canBeConfigured = InputSelectorController.getInputConfigScreenFactory(factory) != null;
        GameInputHandler handler = this.mGame.getConfig().getPlayerInputHandler(this.mPlayerIdx);
        boolean available = handler.isAvailable();
        if (canBeConfigured) {
            this.mConfigureButton.setDisabled(!available);
            this.mConfigureButton.setVisible(true);
        } else {
            this.mConfigureButton.setVisible(false);
        }
        String details = available ? handler.getName() : StringUtils.missingInputHandlerMessage();
        this.mNameLabel.setText(details);
    }

    private static GameInputHandlerConfigScreenFactory getInputConfigScreenFactory(GameInputHandlerFactory factory) {
        if (factory instanceof GamepadInputHandler.Factory) {
            return GamepadConfigScreen::new;
        }
        if (factory instanceof KeyboardInputHandler.Factory) {
            return KeyboardConfigScreen::new;
        }
        return null;
    }
}

