/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.DefaultSoundPlayer;
import com.agateau.pixelwheels.sound.MusicFader;
import com.agateau.pixelwheels.sound.SoundPlayer;
import com.agateau.pixelwheels.sound.SoundThreadManager;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Array;
import java.lang.ref.WeakReference;

public class DefaultAudioManager
implements AudioManager {
    private boolean mSoundFxMuted = false;
    private boolean mMusicMuted = false;
    private final Assets mAssets;
    private final Array<WeakReference<DefaultSoundPlayer>> mSoundPlayers = new Array();
    private final MusicFader mMusicFader = new MusicFader();
    private final SoundThreadManager mSoundThreadManager = new SoundThreadManager();
    private String mMusicId = "";
    private Music mMusic;

    public DefaultAudioManager(Assets assets) {
        this.mAssets = assets;
    }

    @Override
    public boolean areSoundFxMuted() {
        return this.mSoundFxMuted;
    }

    @Override
    public void setSoundFxMuted(boolean muted) {
        if (this.mSoundFxMuted == muted) {
            return;
        }
        this.mSoundFxMuted = muted;
        for (WeakReference weakReference : this.mSoundPlayers) {
            DefaultSoundPlayer player = (DefaultSoundPlayer)weakReference.get();
            if (player == null) continue;
            player.setMuted(muted);
        }
    }

    @Override
    public boolean isMusicMuted() {
        return this.mMusicMuted;
    }

    @Override
    public void setMusicMuted(boolean muted) {
        if (this.mMusicMuted == muted) {
            return;
        }
        this.mMusicMuted = muted;
        if (this.mMusic != null) {
            if (this.mMusicMuted) {
                this.mMusic.stop();
            } else {
                this.mMusic.play();
            }
        }
    }

    @Override
    public void play(Sound sound, float volume) {
        if (this.mSoundFxMuted) {
            return;
        }
        this.mSoundThreadManager.playAndForget(sound, volume);
    }

    @Override
    public SoundPlayer createSoundPlayer(Sound sound) {
        DefaultSoundPlayer player = new DefaultSoundPlayer(this.mSoundThreadManager, sound);
        player.setMuted(this.mSoundFxMuted);
        this.mSoundPlayers.add(new WeakReference<DefaultSoundPlayer>(player));
        return player;
    }

    @Override
    public void playMusic(String musicId) {
        if (this.mMusicId.equals(musicId)) {
            return;
        }
        if (this.mMusic != null) {
            this.fadeOutMusic();
        }
        this.mMusicId = musicId;
        this.mMusic = this.mAssets.loadMusic(this.mMusicId);
        if (this.mMusic == null) {
            NLog.e("Failed to load music %s", musicId);
            return;
        }
        this.mMusic.setLooping(true);
        if (!this.mMusicMuted) {
            this.mMusic.play();
        }
    }

    @Override
    public void fadeOutMusic() {
        if (this.mMusic == null || this.mMusicMuted) {
            return;
        }
        this.mMusicFader.fadeOut(this.mMusic);
        this.mMusic = null;
        this.mMusicId = "";
    }
}

