/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.stats;

import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.utils.CollectionUtils;
import java.util.HashMap;

public class GameStatsImpl
implements GameStats {
    private transient IO mIO;
    private transient GameStats.Listener mListener;
    final HashMap<Difficulty, HashMap<String, TrackStats>> mTrackStatsByDifficulty = new HashMap();
    final HashMap<Difficulty, HashMap<String, Integer>> mBestChampionshipRankByDifficulty = new HashMap();
    final HashMap<String, Integer> mEvents = new HashMap();

    public GameStatsImpl(IO io) {
        for (Difficulty difficulty : Difficulty.values()) {
            this.mBestChampionshipRankByDifficulty.put(difficulty, new HashMap());
            this.mTrackStatsByDifficulty.put(difficulty, new HashMap());
        }
        this.setIO(io);
        this.mIO.load(this);
    }

    public void setIO(IO io) {
        this.mIO = io;
    }

    @Override
    public void setListener(GameStats.Listener listener) {
        this.mListener = listener;
    }

    @Override
    public TrackStats getTrackStats(Difficulty difficulty, Track track) {
        TrackStats stats = this.mTrackStatsByDifficulty.get((Object)difficulty).get(track.getId());
        if (stats == null) {
            stats = new TrackStats(this);
            this.mTrackStatsByDifficulty.get((Object)difficulty).put(track.getId(), stats);
        }
        return stats;
    }

    @Override
    public int getBestChampionshipRank(Difficulty difficulty, Championship championship) {
        HashMap<String, Integer> bestChampionshipRank = this.mBestChampionshipRankByDifficulty.get((Object)difficulty);
        return CollectionUtils.getOrDefault(bestChampionshipRank, championship.getId(), Integer.MAX_VALUE);
    }

    @Override
    public void onChampionshipFinished(Difficulty difficulty, Championship championship, int rank) {
        HashMap<String, Integer> bestChampionshipRank = this.mBestChampionshipRankByDifficulty.get((Object)difficulty);
        Integer currentBest = bestChampionshipRank.get(championship.getId());
        if (currentBest == null || currentBest > rank) {
            bestChampionshipRank.put(championship.getId(), rank);
            this.save();
        }
    }

    @Override
    public void recordEvent(GameStats.Event event) {
        this.recordIntEvent(event, 1);
    }

    @Override
    public void recordIntEvent(GameStats.Event event, int value) {
        int newCount;
        String id = event.toString();
        Integer count = this.mEvents.get(id);
        if (count == null) {
            count = 0;
        }
        if ((newCount = count + value) < count) {
            newCount = Integer.MAX_VALUE;
        }
        this.mEvents.put(id, newCount);
        this.save();
    }

    @Override
    public int getEventCount(GameStats.Event event) {
        return CollectionUtils.getOrDefault(this.mEvents, event.toString(), 0);
    }

    @Override
    public void save() {
        if (this.mListener != null) {
            this.mListener.onChanged();
        }
        this.mIO.save(this);
    }

    public static interface IO {
        public void load(GameStatsImpl var1);

        public void save(GameStatsImpl var1);
    }
}

