/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.stats;

import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.stats.GameStatsImpl;
import com.agateau.pixelwheels.stats.TrackResult;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonGameStatsImplIO
implements GameStatsImpl.IO {
    private static final int CURRENT_VERSION = 2;
    private final FileHandle mHandle;
    private final Gson mGson = new GsonBuilder().setPrettyPrinting().create();

    public JsonGameStatsImplIO(FileHandle handle) {
        this.mHandle = handle;
    }

    @Override
    public void load(GameStatsImpl gameStats) {
        if (!this.mHandle.exists()) {
            return;
        }
        JsonParser parser = new JsonParser();
        String json = this.mHandle.readString("UTF-8");
        JsonObject root = parser.parse(json).getAsJsonObject();
        int version = root.has("version") ? root.get("version").getAsInt() : 1;
        switch (version) {
            case 2: {
                this.loadV2(gameStats, root);
                return;
            }
            case 1: {
                this.loadV1(gameStats, root);
                return;
            }
        }
        NLog.e("Don't know how to load stats from version %d, not loading anything", version);
    }

    private void loadV1(GameStatsImpl gameStats, JsonObject root) {
        Difficulty difficulty = Difficulty.HARD;
        JsonObject trackStatsObject = root.getAsJsonObject("trackStats");
        if (trackStatsObject != null) {
            HashMap<String, TrackStats> trackStatsByTrack = gameStats.mTrackStatsByDifficulty.get((Object)difficulty);
            trackStatsByTrack.clear();
            for (Map.Entry<String, JsonElement> kv : trackStatsObject.entrySet()) {
                String trackId = kv.getKey();
                TrackStats trackStats = new TrackStats(gameStats);
                trackStatsByTrack.put(trackId, trackStats);
                this.loadTrackStats(trackStats, kv.getValue().getAsJsonObject());
            }
        }
        JsonObject ranksObject = root.getAsJsonObject("bestChampionshipRank");
        JsonGameStatsImplIO.loadStringIntMap((Map<String, Integer>)gameStats.mBestChampionshipRankByDifficulty.get((Object)difficulty), ranksObject);
        JsonGameStatsImplIO.loadStringIntMap(gameStats.mEvents, root.getAsJsonObject("events"));
    }

    private void loadV2(GameStatsImpl gameStats, JsonObject root) {
        JsonObject trackStatsByDifficultyObject = root.getAsJsonObject("trackStats");
        for (Difficulty difficulty : Difficulty.values()) {
            JsonObject trackStatsObject = trackStatsByDifficultyObject.getAsJsonObject(difficulty.name());
            if (trackStatsObject == null) continue;
            HashMap<String, TrackStats> trackStatsByTrack = gameStats.mTrackStatsByDifficulty.get((Object)difficulty);
            trackStatsByTrack.clear();
            for (Map.Entry<String, JsonElement> kv : trackStatsObject.entrySet()) {
                String trackId = kv.getKey();
                TrackStats trackStats = new TrackStats(gameStats);
                trackStatsByTrack.put(trackId, trackStats);
                this.loadTrackStats(trackStats, kv.getValue().getAsJsonObject());
            }
        }
        JsonObject ranksByDifficultyObject = root.getAsJsonObject("bestChampionshipRank");
        for (Difficulty difficulty : Difficulty.values()) {
            JsonGameStatsImplIO.loadStringIntMap((Map<String, Integer>)gameStats.mBestChampionshipRankByDifficulty.get((Object)difficulty), ranksByDifficultyObject.getAsJsonObject(difficulty.name()));
        }
        JsonGameStatsImplIO.loadStringIntMap(gameStats.mEvents, root.getAsJsonObject("events"));
    }

    private void loadTrackStats(TrackStats trackStats, JsonObject object) {
        this.loadResults(trackStats.mLapRecords, object.getAsJsonArray("lap"));
        this.loadResults(trackStats.mTotalRecords, object.getAsJsonArray("total"));
    }

    private static void loadStringIntMap(Map<String, Integer> map, JsonObject object) {
        map.clear();
        if (object == null) {
            return;
        }
        for (Map.Entry<String, JsonElement> kv : object.entrySet()) {
            String id = kv.getKey();
            int value = kv.getValue().getAsInt();
            map.put(id, value);
        }
    }

    private void loadResults(ArrayList<TrackResult> results, JsonArray array) {
        results.clear();
        for (JsonElement element : array) {
            TrackResult result = this.mGson.fromJson(element, TrackResult.class);
            results.add(result);
        }
    }

    @Override
    public void save(GameStatsImpl gameStats) {
        JsonObject root = new JsonObject();
        root.addProperty("version", 2);
        JsonObject trackStatsByDifficultyObject = new JsonObject();
        root.add("trackStats", trackStatsByDifficultyObject);
        for (Difficulty difficulty : Difficulty.values()) {
            JsonObject trackStatsObject = new JsonObject();
            trackStatsByDifficultyObject.add(difficulty.name(), trackStatsObject);
            for (Map.Entry<String, TrackStats> kv : gameStats.mTrackStatsByDifficulty.get((Object)difficulty).entrySet()) {
                trackStatsObject.add(kv.getKey(), this.createJsonForTrack(kv.getValue()));
            }
        }
        root.add("bestChampionshipRank", this.mGson.toJsonTree(gameStats.mBestChampionshipRankByDifficulty));
        root.add("events", this.mGson.toJsonTree(gameStats.mEvents));
        String json = this.mGson.toJson(root);
        this.mHandle.writeString(json, false);
    }

    private JsonObject createJsonForTrack(TrackStats trackStats) {
        JsonObject root = new JsonObject();
        root.add("lap", this.createJsonForResults(trackStats.get(TrackStats.ResultType.LAP)));
        root.add("total", this.createJsonForResults(trackStats.get(TrackStats.ResultType.TOTAL)));
        return root;
    }

    private JsonArray createJsonForResults(ArrayList<TrackResult> results) {
        JsonArray array = new JsonArray();
        for (TrackResult result : results) {
            if (result.vehicle.equals("CPU")) continue;
            array.add(this.mGson.toJsonTree(result));
        }
        return array;
    }
}

