/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.vehicledef;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.vehicledef.AxleDef;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;

public class VehicleCreator {
    private final GameWorld mGameWorld;
    private final Assets mAssets;
    private final Vector2 sWheelPos = new Vector2();

    public VehicleCreator(Assets assets, GameWorld gameWorld) {
        this.mGameWorld = gameWorld;
        this.mAssets = assets;
    }

    public Vehicle create(VehicleDef vehicleDef, Vector2 position, float angle, int maxDrivingForce) {
        float U = 0.05f;
        float drivingForce = (float)maxDrivingForce * vehicleDef.speed;
        TextureRegion mainRegion = vehicleDef.getImage(this.mAssets);
        Vehicle vehicle = new Vehicle(this.mAssets, this.mGameWorld, position.x, position.y, vehicleDef, angle);
        for (AxleDef axle : vehicleDef.axles) {
            float wheelY = axle.width * 0.05f / 2.0f;
            float wheelX = (axle.y - (float)mainRegion.getRegionWidth() / 2.0f) * 0.05f;
            float drive = drivingForce * axle.drive;
            TextureRegion wheelRegion = axle.getTexture(this.mAssets);
            Animation<TextureRegion> splashAnimation = axle.getSplashAnimation(this.mAssets);
            this.sWheelPos.set(wheelX, wheelY).rotate(angle);
            this.createWheel(vehicle, wheelRegion, splashAnimation, this.sWheelPos.x, this.sWheelPos.y, axle, drive, angle);
            this.sWheelPos.set(wheelX, -wheelY).rotate(angle);
            this.createWheel(vehicle, wheelRegion, splashAnimation, this.sWheelPos.x, this.sWheelPos.y, axle, drive, angle);
        }
        return vehicle;
    }

    private void createWheel(Vehicle vehicle, TextureRegion region, Animation<TextureRegion> splashAnimation, float x, float y, AxleDef axle, float drive, float angle) {
        Vehicle.WheelInfo info = vehicle.addWheel(region, splashAnimation, axle.tireSize.getDensity(), x, y, angle);
        info.steeringFactor = axle.steer;
        info.wheel.setCanDrift(axle.drift);
        info.wheel.setMaxDrivingForce(drive);
    }
}

