/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;

public class MouseCursorManager {
    private static final long AUTOHIDE_DELAY = 4000L;
    private final Cursor mEmptyCursor;
    private Cursor mCursor;
    private int mOldX;
    private int mOldY;
    private long mTimestamp;
    private boolean mIsVisible = false;
    private boolean mReady = false;
    private static MouseCursorManager sInstance;

    public static MouseCursorManager getInstance() {
        if (sInstance == null) {
            sInstance = new MouseCursorManager();
        }
        return sInstance;
    }

    private MouseCursorManager() {
        Pixmap pixmap = new Pixmap(2, 2, Pixmap.Format.RGBA8888);
        pixmap.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        pixmap.fill();
        this.mEmptyCursor = Gdx.graphics.newCursor(pixmap, 0, 0);
    }

    public void setCursorPixmap(FileHandle fileHandle) {
        if (this.mCursor != null) {
            this.mCursor.dispose();
        }
        Pixmap pixmap = new Pixmap(fileHandle);
        this.mCursor = Gdx.graphics.newCursor(pixmap, 0, 0);
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void act() {
        if (this.mCursor == null) {
            return;
        }
        if (!this.mReady) {
            this.actNotReady();
            return;
        }
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        boolean hasMoved = x != this.mOldX || y != this.mOldY;
        long now = System.currentTimeMillis();
        if (hasMoved) {
            this.mOldX = x;
            this.mOldY = y;
            this.mTimestamp = now;
            if (!this.mIsVisible) {
                this.showMouseCursor();
            }
        } else if (this.mIsVisible && now - this.mTimestamp > 4000L) {
            this.hideMouseCursor();
        }
    }

    private void actNotReady() {
        this.hideMouseCursor();
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        if (x == 0 && y == 0) {
            return;
        }
        this.mReady = true;
        this.mOldX = x;
        this.mOldY = y;
        this.mTimestamp = System.currentTimeMillis();
    }

    private void showMouseCursor() {
        this.mIsVisible = true;
        Gdx.graphics.setCursor(this.mCursor);
    }

    private void hideMouseCursor() {
        this.mIsVisible = false;
        Gdx.graphics.setCursor(this.mEmptyCursor);
    }
}

