/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.Viewport;

public abstract class StageScreen
extends ScreenAdapter {
    private final Stage mStage;
    private final Viewport mViewport;
    private final InputMultiplexer mInputMultiplexer;

    public StageScreen(Viewport viewport) {
        this.mViewport = viewport;
        this.mStage = new Stage(this.mViewport);
        this.mInputMultiplexer = new InputMultiplexer();
        this.mInputMultiplexer.addProcessor(this.mStage);
    }

    public void prependInputProcessor(InputProcessor inputProcessor) {
        this.mInputMultiplexer.addProcessor(0, inputProcessor);
    }

    public Stage getStage() {
        return this.mStage;
    }

    @Override
    public void show() {
        super.show();
        Gdx.input.setInputProcessor(this.mInputMultiplexer);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.mStage.act(delta);
        if (this.isBackKeyPressed()) {
            this.onBackPressed();
        }
        this.mStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.mViewport.update(width, height, true);
    }

    public abstract void onBackPressed();

    public abstract boolean isBackKeyPressed();
}

