/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.FontSet;
import com.agateau.ui.StrictTextureAtlas;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Disposable;

public class UiAssets
implements Disposable {
    public final Skin skin;
    public final TextureAtlas atlas = new StrictTextureAtlas(FileUtils.assets("ui/uiskin.atlas"));
    public final TextureRegion background = this.atlas.findRegion("background");
    private static final float SMALL_HUD_RATIO = 0.7f;
    private static final Color HUD_BORDER_COLOR = Color.valueOf("#3a4466");

    public UiAssets(FontSet fontSet) {
        this(fontSet, "");
    }

    public UiAssets(FontSet fontSet, String extraCharacters) {
        this.skin = new Skin(this.atlas);
        this.loadFontSet(fontSet, extraCharacters);
        this.skin.load(FileUtils.assets("ui/uiskin.gdxjson"));
    }

    @Override
    public void dispose() {
        this.skin.dispose();
        this.atlas.dispose();
    }

    private void loadFontSet(FontSet fontSet, String characters) {
        characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff" + characters;
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = fontSet.defaultFontSize;
        parameter.characters = characters;
        this.skin.add("default-font", this.loadFont("fonts/" + fontSet.defaultFontName, parameter));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = fontSet.defaultFontSize;
        parameter.characters = "*\u2b58\u23fd";
        this.skin.add("symbols-font", this.loadFont("fonts/NotoSansSymbols2-Regular.ttf", parameter));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = fontSet.titleFontSize;
        parameter.characters = characters;
        this.skin.add("title-font", this.loadFont("fonts/" + fontSet.titleFontName, parameter));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = 12;
        parameter.borderWidth = 0.5f;
        parameter.characters = characters;
        this.skin.add("tiny-font", this.loadFont("fonts/" + fontSet.defaultFontName, parameter));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = (int)((float)fontSet.defaultFontSize * 0.5f);
        parameter.characters = characters;
        this.skin.add("tiny-bold-font", this.loadFont("fonts/" + fontSet.defaultBoldFontName, parameter));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = (int)((float)fontSet.defaultFontSize * 0.8f);
        parameter.borderWidth = 0.5f;
        parameter.characters = characters;
        this.skin.add("small-font", this.loadFont("fonts/" + fontSet.defaultFontName, parameter));
        parameter = UiAssets.createHudFontParameter();
        parameter.size = fontSet.defaultFontSize;
        parameter.characters = characters;
        this.skin.add("hud-font", this.loadFont("fonts/" + fontSet.hudFontName, parameter));
        parameter.size = (int)((float)parameter.size * 0.7f);
        this.skin.add("small-hud-font", this.loadFont("fonts/" + fontSet.hudFontName, parameter));
        parameter = UiAssets.createHudFontParameter();
        parameter.size = 56;
        parameter.characters = characters;
        this.skin.add("hud-rank-font", this.loadFont("fonts/" + fontSet.hudFontName, parameter));
        parameter.size = (int)((float)parameter.size * 0.7f);
        this.skin.add("small-hud-rank-font", this.loadFont("fonts/" + fontSet.hudFontName, parameter));
        parameter = UiAssets.createHudFontParameter();
        parameter.size = 180;
        parameter.characters = "123GO!";
        this.skin.add("hud-countdown-font", this.loadFont("fonts/" + fontSet.hudFontName, parameter));
    }

    private static FreeTypeFontGenerator.FreeTypeFontParameter createHudFontParameter() {
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.borderWidth = 1.0f;
        parameter.borderColor = HUD_BORDER_COLOR;
        return parameter;
    }

    private BitmapFont loadFont(String name, FreeTypeFontGenerator.FreeTypeFontParameter parameter) {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(FileUtils.assets(name));
        BitmapFont font = generator.generateFont(parameter);
        generator.dispose();
        return font;
    }
}

