/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.anchor;

import com.agateau.ui.anchor.AnchorRule;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class SizeRule
implements AnchorRule {
    public static final float KEEP_RATIO = -1.0f;
    public static final float IGNORE = -2.0f;
    private final Actor mTarget;
    private final Actor mReference;
    private final float mWidthPercent;
    private final float mHeightPercent;
    private float mWidthPadding = 0.0f;
    private float mHeightPadding = 0.0f;

    public SizeRule(Actor target, Actor reference, float widthPercent, float heightPercent) {
        this.mTarget = target;
        this.mReference = reference;
        this.mWidthPercent = widthPercent;
        this.mHeightPercent = heightPercent;
    }

    public SizeRule setPadding(float width, float height) {
        this.mWidthPadding = width;
        this.mHeightPadding = height;
        return this;
    }

    @Override
    public Actor getTarget() {
        return this.mTarget;
    }

    @Override
    public void apply() {
        if (this.mWidthPercent > 0.0f) {
            this.mTarget.setWidth(this.mReference.getWidth() * this.mWidthPercent + this.mWidthPadding);
        }
        if (this.mHeightPercent > 0.0f) {
            this.mTarget.setHeight(this.mReference.getHeight() * this.mHeightPercent + this.mHeightPadding);
        }
        if (this.mWidthPercent == -1.0f) {
            if (this.mTarget.getHeight() == 0.0f) {
                return;
            }
            float wfh = this.mTarget.getWidth() / this.mTarget.getHeight();
            this.mTarget.setWidth(this.mTarget.getHeight() * wfh + this.mWidthPadding);
        }
        if (this.mHeightPercent == -1.0f) {
            if (this.mTarget.getWidth() == 0.0f) {
                return;
            }
            float hfw = this.mTarget.getHeight() / this.mTarget.getWidth();
            this.mTarget.setHeight(this.mTarget.getWidth() * hfw + this.mHeightPadding);
        }
    }
}

