/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.Assert;
import com.agateau.utils.DesktopDirs;
import com.agateau.utils.PlatformUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.XmlReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    public static String appName;
    private static FileHandle sExtraAssetsHandle;
    private static DesktopDirs sCachedDesktopDirs;

    public static FileHandle getUserWritableFile(String name) {
        FileHandle handle;
        if (PlatformUtils.isDesktop()) {
            String path = FileUtils.getDesktopDataDir() + File.separator + name;
            handle = Gdx.files.absolute(path);
        } else {
            handle = Gdx.files.local(name);
        }
        return handle;
    }

    public static String getDesktopConfigDir() {
        return FileUtils.getDesktopDirs().getConfigDir();
    }

    public static String getDesktopLegacyConfigDir() {
        return System.getProperty("user.home") + File.separator + ".config" + File.separator + "agateau.com";
    }

    public static String getDesktopCacheDir() {
        return FileUtils.getDesktopDirs().getCacheDir();
    }

    public static String getDesktopDataDir() {
        return FileUtils.getDesktopDirs().getDataDir();
    }

    public static void setExtraAssetsDir(String dir) {
        FileHandle handle = Gdx.files.absolute(dir);
        if (!handle.isDirectory()) {
            NLog.e("'%s' is not a directory", dir);
            return;
        }
        NLog.i("Set '%s' as the extra asset directory", handle.path());
        sExtraAssetsHandle = handle;
    }

    public static FileHandle assets(String path) {
        FileHandle handle;
        if (sExtraAssetsHandle != null && (handle = sExtraAssetsHandle.child(path)).exists()) {
            return handle;
        }
        return Gdx.files.internal(path);
    }

    public static XmlReader.Element parseXml(FileHandle handle) {
        XmlReader reader = new XmlReader();
        XmlReader.Element root = reader.parse(handle);
        if (root == null) {
            NLog.e("Failed to parse xml file from %s. No root element.", handle.path());
            return null;
        }
        return root;
    }

    public static String readUtf8(InputStream in) throws IOException {
        int length;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        while ((length = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, length);
        }
        return sb.toString();
    }

    private static DesktopDirs getDesktopDirs() {
        if (sCachedDesktopDirs == null) {
            Assert.check(appName != null, "appName has not been set", new Object[0]);
            sCachedDesktopDirs = new DesktopDirs(appName, System.getenv());
        }
        return sCachedDesktopDirs;
    }
}

