/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.lwawt.macosx.CPrinterGraphics;
import sun.lwawt.macosx.CPrinterJobDialog;
import sun.lwawt.macosx.CPrinterPageDialog;
import sun.lwawt.macosx.CPrinterSurfaceData;
import sun.lwawt.macosx.LWCToolkit;
import sun.print.PeekGraphics;
import sun.print.RasterPrinterJob;
import sun.print.SunPageSelection;

public final class CPrinterJob
extends RasterPrinterJob {
    private static String sShouldNotReachHere = "Should not reach here.";
    private volatile SecondaryLoop printingLoop;
    private boolean noDefaultPrinter = false;
    private static Font defaultFont;
    private long fNSPrintInfo = -1L;
    private Object fNSPrintInfoLock = new Object();
    volatile boolean onEventThread;

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (this.getPrintService() instanceof StreamPrintService) {
            return super.printDialog(this.attributes);
        }
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    @Override
    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return pageFormat;
        }
        if (this.getPrintService() instanceof StreamPrintService) {
            return super.pageDialog(pageFormat);
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = this.pageSetup(pageFormat2, null);
        return bl ? pageFormat2 : pageFormat;
    }

    @Override
    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    @Override
    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        SunPageSelection sunPageSelection;
        super.setAttributes(printRequestAttributeSet);
        if (printRequestAttributeSet == null) {
            return;
        }
        PageRanges pageRanges = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
        if (this.isSupportedValue(pageRanges, printRequestAttributeSet) && ((sunPageSelection = (SunPageSelection)printRequestAttributeSet.get(SunPageSelection.class)) == null || sunPageSelection == SunPageSelection.RANGE)) {
            int[][] nArray = pageRanges.getMembers();
            this.setPageRange(nArray[0][0] - 1, nArray[0][1] - 1);
        }
    }

    @Override
    protected void cancelDoc() throws PrinterAbortException {
        super.cancelDoc();
        if (this.printingLoop != null) {
            this.printingLoop.exit();
        }
    }

    private void completePrintLoop() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    CPrinterJob.this.performingPrinting = false;
                }
                if (CPrinterJob.this.printingLoop != null) {
                    CPrinterJob.this.printingLoop.exit();
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        CPrinterJob cPrinterJob;
        int n;
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        if (printService instanceof StreamPrintService) {
            this.spoolToService(printService, printRequestAttributeSet);
            return;
        }
        this.setAttributes(printRequestAttributeSet);
        if (this.destinationAttr != null) {
            this.validateDestination(this.destinationAttr);
        }
        int n2 = this.getFirstPage();
        int n3 = this.getLastPage();
        if (n3 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n3 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            cPrinterJob = this;
            synchronized (cPrinterJob) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            cPrinterJob = printRequestAttributeSet == null ? null : (PageRanges)printRequestAttributeSet.get(PageRanges.class);
            int[][] nArray = cPrinterJob == null ? new int[0][0] : ((SetOfIntegerSyntax)((Object)cPrinterJob)).getMembers();
            int n4 = 0;
            do {
                if (EventQueue.isDispatchThread()) {
                    this.onEventThread = true;
                    this.printingLoop = AccessController.doPrivileged(new PrivilegedAction<SecondaryLoop>(){

                        @Override
                        public SecondaryLoop run() {
                            return Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                        }
                    });
                    try {
                        if (this.printLoop(false, n2, n3)) {
                            this.printingLoop.enter();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.onEventThread = false;
                    try {
                        this.printLoop(true, n2, n3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (++n4 >= nArray.length) continue;
                n2 = nArray[n4][0] - 1;
                n3 = nArray[n4][1] - 1;
            } while (n4 < nArray.length);
        }
        finally {
            cPrinterJob = this;
            synchronized (cPrinterJob) {
                this.performingPrinting = false;
                this.notify();
            }
            if (this.printingLoop != null) {
                this.printingLoop.exit();
            }
        }
    }

    @Override
    protected double getXRes() {
        return 0.0;
    }

    @Override
    protected double getYRes() {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPageWidth(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPageHeight(Paper paper) {
        return 0.0;
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void startDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void endDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected native void abortDoc();

    public boolean pageSetup(PageFormat pageFormat, Printable printable) {
        CPrinterPageDialog cPrinterPageDialog = new CPrinterPageDialog(null, this, pageFormat, printable);
        cPrinterPageDialog.setVisible(true);
        boolean bl = cPrinterPageDialog.getRetVal();
        cPrinterPageDialog.dispose();
        return bl;
    }

    private boolean jobSetup(Pageable pageable, boolean bl) {
        CPrinterJobDialog cPrinterJobDialog = new CPrinterJobDialog(null, this, pageable, bl);
        cPrinterJobDialog.setVisible(true);
        boolean bl2 = cPrinterJobDialog.getRetVal();
        cPrinterJobDialog.dispose();
        return bl2;
    }

    private native void getDefaultPage(PageFormat var1);

    @Override
    protected native void validatePaper(Paper var1, Paper var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo != -1L) {
                this.dispose(this.fNSPrintInfo);
            }
            this.fNSPrintInfo = -1L;
        }
    }

    private native long createNSPrintInfo();

    private native void dispose(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNSPrintInfo() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo == -1L) {
                this.fNSPrintInfo = this.createNSPrintInfo();
            }
            return this.fNSPrintInfo;
        }
    }

    private native boolean printLoop(boolean var1, int var2, int var3) throws PrinterException;

    private PageFormat getPageFormat(int n) {
        PageFormat pageFormat;
        try {
            pageFormat = this.getPageable().getPageFormat(n);
        }
        catch (Exception exception) {
            return null;
        }
        return pageFormat;
    }

    private Printable getPrintable(int n) {
        Printable printable;
        try {
            printable = this.getPageable().getPrintable(n);
        }
        catch (Exception exception) {
            return null;
        }
        return printable;
    }

    private String getPrinterName() {
        PrintService printService = this.getPrintService();
        if (printService == null) {
            return null;
        }
        return printService.getName();
    }

    private void setPrinterServiceFromNative(String string) {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            PrintService printService = printServiceArray[i];
            if (!string.equals(printService.getName())) continue;
            try {
                this.setPrintService(printService);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return;
        }
    }

    private Rectangle2D getPageFormatArea(PageFormat pageFormat) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        return double_;
    }

    private boolean cancelCheck() {
        boolean bl;
        boolean bl2 = bl = this.performingPrinting && this.userCancelled;
        if (bl) {
            try {
                LWCToolkit.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CPrinterJob.this.cancelDoc();
                        }
                        catch (PrinterAbortException printerAbortException) {
                            // empty catch block
                        }
                    }
                }, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return bl;
    }

    private PeekGraphics createFirstPassGraphics(PrinterJob printerJob, PageFormat pageFormat) {
        BufferedImage bufferedImage = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), printerJob);
        Rectangle2D rectangle2D = this.getPageFormatArea(pageFormat);
        this.initPrinterGraphics(peekGraphics, rectangle2D);
        return peekGraphics;
    }

    private void printToPathGraphics(PeekGraphics peekGraphics, final PrinterJob printerJob, final Printable printable, final PageFormat pageFormat, final int n, final long l) throws PrinterException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SurfaceData surfaceData = CPrinterSurfaceData.createData(pageFormat, l);
                    if (defaultFont == null) {
                        defaultFont = new Font("Dialog", 0, 12);
                    }
                    SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData, Color.black, Color.white, defaultFont);
                    CPrinterGraphics cPrinterGraphics = new CPrinterGraphics(sunGraphics2D, printerJob);
                    Rectangle2D rectangle2D = CPrinterJob.this.getPageFormatArea(pageFormat);
                    CPrinterJob.this.initPrinterGraphics(cPrinterGraphics, rectangle2D);
                    printable.print(cPrinterGraphics, pageFormat, n);
                    ((Graphics)sunGraphics2D).dispose();
                    sunGraphics2D = null;
                }
                catch (PrinterException printerException) {
                    throw new UndeclaredThrowableException(printerException);
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof PrinterException) {
                    throw (PrinterException)throwable;
                }
                throwable.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getPageformatPrintablePeekgraphics(final int n) {
        final Object[] objectArray = new Object[3];
        final CPrinterJob cPrinterJob = this;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] objectArray2 = objectArray;
                synchronized (objectArray) {
                    try {
                        Printable printable;
                        Pageable pageable = CPrinterJob.this.getPageable();
                        PageFormat pageFormat = pageable.getPageFormat(n);
                        if (pageFormat != null && (printable = pageable.getPrintable(n)) != null) {
                            BufferedImage bufferedImage = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
                            PeekGraphics peekGraphics = CPrinterJob.this.createPeekGraphics(bufferedImage.createGraphics(), cPrinterJob);
                            Rectangle2D rectangle2D = CPrinterJob.this.getPageFormatArea(pageFormat);
                            CPrinterJob.this.initPrinterGraphics(peekGraphics, rectangle2D);
                            objectArray[0] = pageFormat;
                            objectArray[1] = printable;
                            objectArray[2] = peekGraphics;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            runnable.run();
        }
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            if (objectArray[2] != null) {
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return objectArray;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D printAndGetPageFormatArea(final Printable printable, final Graphics graphics, final PageFormat pageFormat, final int n) {
        final Rectangle2D[] rectangle2DArray = new Rectangle2D[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Rectangle2D[] rectangle2DArray2 = rectangle2DArray;
                synchronized (rectangle2DArray) {
                    try {
                        int n2 = printable.print(graphics, pageFormat, n);
                        if (n2 != 1) {
                            rectangle2DArray[0] = CPrinterJob.this.getPageFormatArea(pageFormat);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            runnable.run();
        }
        Rectangle2D[] rectangle2DArray2 = rectangle2DArray;
        synchronized (rectangle2DArray) {
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return rectangle2DArray[0];
        }
    }

    private static void detachPrintLoop(final long l, final long l2) {
        new Thread(){

            @Override
            public void run() {
                CPrinterJob._safePrintLoop(l, l2);
            }
        }.start();
    }

    private static native void _safePrintLoop(long var0, long var2);

    @Override
    protected void startPage(PageFormat pageFormat, Printable printable, int n, boolean bl) throws PrinterException {
    }

    @Override
    protected MediaSize getMediaSize(Media media, PrintService printService, PageFormat pageFormat) {
        if (media == null || !(media instanceof MediaSizeName)) {
            return this.getDefaultMediaSize(pageFormat);
        }
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
        return mediaSize != null ? mediaSize : this.getDefaultMediaSize(pageFormat);
    }

    private MediaSize getDefaultMediaSize(PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        float f = (float)(paper.getWidth() / 72.0);
        float f2 = (float)(paper.getHeight() / 72.0);
        return new MediaSize(f, f2, 25400);
    }

    @Override
    protected MediaPrintableArea getDefaultPrintableArea(PageFormat pageFormat, double d, double d2) {
        Paper paper = pageFormat.getPaper();
        return new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
    }

    static {
        Toolkit.getDefaultToolkit();
    }
}

