/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;

public class BonusSpot
extends GameObjectAdapter {
    private static final float DISABLED_TIMEOUT = 5.0f;
    private final TextureRegion mRegion;
    private final Sound mSound;
    private final AudioManager mAudioManager;
    private final float mX;
    private final float mY;
    private final Body mBody;
    private float mDisabledTimeout = 0.0f;
    private final BodyRegionDrawer mDrawer = new BodyRegionDrawer();
    private boolean mJustPicked = false;
    private static float sRegionRadiusU = 0.0f;

    public BonusSpot(Assets assets, AudioManager audioManager, GameWorld gameWorld, float x, float y) {
        float U = 0.05f;
        this.mAudioManager = audioManager;
        this.mX = x;
        this.mY = y;
        this.mRegion = assets.gift;
        if (sRegionRadiusU == 0.0f) {
            sRegionRadiusU = DrawUtils.getTextureRegionRadius(this.mRegion) * 0.05f;
        }
        this.mSound = assets.soundAtlas.get("bonus");
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(0.05f * (float)this.mRegion.getRegionWidth() / 2.0f, 0.05f * (float)this.mRegion.getRegionHeight() / 2.0f);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.position.set(this.mX, this.mY);
        this.mBody = gameWorld.getBox2DWorld().createBody(bodyDef);
        Fixture fixture = this.mBody.createFixture(shape, 1.0f);
        fixture.setSensor(true);
        this.mBody.setUserData(this);
        this.mBody.setAngularVelocity(4.1887903f);
        shape.dispose();
    }

    @Override
    public void act(float delta) {
        if (this.mDisabledTimeout > 0.0f) {
            this.mBody.setActive(false);
            this.mDisabledTimeout -= delta;
            if (this.mDisabledTimeout <= 0.0f) {
                this.mDisabledTimeout = 0.0f;
                this.mBody.setActive(true);
            }
        }
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (!this.mBody.isActive()) {
            return;
        }
        if (!AgcMathUtils.rectangleContains(viewBounds, this.getPosition(), sRegionRadiusU)) {
            return;
        }
        if (zLevel == ZLevel.GROUND) {
            this.mDrawer.setBatch(batch);
            this.mDrawer.drawShadow(this.mBody, this.mRegion);
        } else if (zLevel == ZLevel.ON_GROUND) {
            this.mDrawer.setBatch(batch);
            this.mDrawer.draw(this.mBody, this.mRegion);
        }
    }

    @Override
    public void audioRender(AudioClipper audioClipper) {
        if (this.mJustPicked) {
            float volume = audioClipper.clip(this);
            this.mAudioManager.play(this.mSound, volume);
            this.mJustPicked = false;
        }
    }

    @Override
    public float getX() {
        return this.mX;
    }

    @Override
    public float getY() {
        return this.mY;
    }

    public void pickBonus() {
        this.mDisabledTimeout = 5.0f;
        this.mJustPicked = true;
    }
}

