/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.BodyIdentifier;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.utils.ArcClosestBodyFinder;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;

public class ClosestRacerFinder {
    private final ArcClosestBodyFinder mBodyFinder;
    private final RacerBodyFilter mFilter = new RacerBodyFilter();

    public ClosestRacerFinder(float depth) {
        this(depth, 0.0f);
    }

    public ClosestRacerFinder(float depth, float arc) {
        this.mBodyFinder = new ArcClosestBodyFinder(depth, arc);
        this.mBodyFinder.setBodyFilter(this.mFilter);
    }

    public void setIgnoredRacer(Racer ignoredRacer) {
        this.mFilter.mIgnoredRacer = ignoredRacer;
    }

    public Racer find(World world, Vector2 origin, float angle) {
        Body body = this.mBodyFinder.find(world, origin, angle);
        if (body == null) {
            return null;
        }
        return (Racer)body.getUserData();
    }

    public Vector2 getLeftVertex(Vector2 origin, float angle) {
        return this.mBodyFinder.getLeftVertex(origin, angle);
    }

    public Vector2 getRightVertex(Vector2 origin, float angle) {
        return this.mBodyFinder.getRightVertex(origin, angle);
    }

    private static class RacerBodyFilter
    implements ArcClosestBodyFinder.BodyFilter {
        Racer mIgnoredRacer;

        private RacerBodyFilter() {
        }

        @Override
        public ArcClosestBodyFinder.FilterResult filter(Body body) {
            if (BodyIdentifier.isStaticObstacle(body)) {
                return ArcClosestBodyFinder.FilterResult.STOP_FAILED;
            }
            Object userData = body.getUserData();
            if (!(userData instanceof Racer) || userData == this.mIgnoredRacer) {
                return ArcClosestBodyFinder.FilterResult.IGNORE;
            }
            return ArcClosestBodyFinder.FilterResult.STOP_SUCCESS;
        }
    }
}

