/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Renderer;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.bonus.BonusAdapter;
import com.agateau.pixelwheels.bonus.Bullet;
import com.agateau.pixelwheels.bonus.ClosestRacerFinder;
import com.agateau.pixelwheels.debug.DebugShapeMap;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Pool;

public class GunBonus
extends BonusAdapter
implements Pool.Poolable {
    private static final float SHOOT_INTERVAL = 0.1f;
    private static final int SHOOT_COUNT = 20;
    private static final float SPREAD_ANGLE = 5.0f;
    private static final float AI_RAYCAST_LENGTH = 20.0f;
    private final ClosestRacerFinder mClosestRacerFinder = new ClosestRacerFinder(20.0f);
    private boolean mTriggered;
    private float mAnimationTime;
    private float mDelayForNextShot;
    private int mRemainingShots;
    private final Renderer mBonusRenderer = new Renderer(){

        @Override
        public void drawToCell(Batch batch, float centerX, float centerY) {
            TextureRegion region = GunBonus.this.mAssets.gunAnimation.getKeyFrame(GunBonus.this.mAnimationTime, true);
            Vehicle vehicle = GunBonus.this.mRacer.getVehicle();
            Body body = vehicle.getBody();
            float angle = body.getAngle() * 57.295776f;
            float w = region.getRegionWidth();
            float h = region.getRegionHeight();
            batch.draw(region, centerX - w / 2.0f, centerY - h / 2.0f, w / 2.0f, h / 2.0f, w, h, 1.0f, 1.0f, angle - 90.0f);
        }

        @Override
        public void draw(Batch batch, ZLevel zLevel) {
        }
    };
    private final Vector2 mRayCastOrigin = new Vector2();
    private final DebugShapeMap.Shape mDebugShape = renderer -> {
        float angle = this.mRacer.getVehicle().getAngle();
        renderer.begin(ShapeRenderer.ShapeType.Line);
        renderer.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        renderer.line(this.mRayCastOrigin, this.mClosestRacerFinder.getLeftVertex(this.mRayCastOrigin, angle));
        renderer.line(this.mRayCastOrigin, this.mClosestRacerFinder.getRightVertex(this.mRayCastOrigin, angle));
        renderer.end();
    };

    public GunBonus() {
        this.reset();
    }

    @Override
    public void reset() {
        this.mTriggered = false;
        this.mAnimationTime = 0.0f;
        this.mDelayForNextShot = 0.0f;
        this.mRemainingShots = 20;
    }

    @Override
    public void onPicked(Racer racer) {
        super.onPicked(racer);
        this.mRacer.getVehicleRenderer().addRenderer(this.mBonusRenderer);
        this.mClosestRacerFinder.setIgnoredRacer(this.mRacer);
        DebugShapeMap.put(this, this.mDebugShape);
    }

    @Override
    public void onOwnerHit() {
        this.resetBonus();
    }

    @Override
    public void trigger() {
        this.mTriggered = true;
        this.mDelayForNextShot = 0.0f;
        DebugShapeMap.remove(this);
    }

    @Override
    public void act(float delta) {
        if (!this.mTriggered) {
            return;
        }
        this.mAnimationTime += delta;
        this.mDelayForNextShot -= delta;
        if (this.mDelayForNextShot > 0.0f) {
            return;
        }
        Vehicle vehicle = this.mRacer.getVehicle();
        float angle = vehicle.getAngle() + MathUtils.random(-5.0f, 5.0f);
        Bullet bullet = Bullet.create(this.mAssets, this.mGameWorld, this.mAudioManager, this.mRacer, vehicle.getX(), vehicle.getY(), angle);
        this.mGameWorld.addGameObject(bullet);
        --this.mRemainingShots;
        if (this.mRemainingShots == 0) {
            this.resetBonus();
        } else {
            this.mDelayForNextShot = 0.1f;
        }
    }

    @Override
    public void aiAct(float delta) {
        this.mRayCastOrigin.set(this.mRacer.getX(), this.mRacer.getY());
        World world = this.mGameWorld.getBox2DWorld();
        Racer racer = this.mClosestRacerFinder.find(world, this.mRayCastOrigin, this.mRacer.getVehicle().getAngle());
        if (racer != null) {
            this.mRacer.triggerBonus();
        }
    }

    private void resetBonus() {
        this.mRacer.getVehicleRenderer().removeRenderer(this.mBonusRenderer);
        this.free();
        this.mRacer.resetBonus();
    }
}

