/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.Assert;
import com.badlogic.gdx.utils.Array;

public class ChampionshipGameInfo
extends GameInfo {
    private Championship mChampionship;
    private int mTrackIndex = 0;

    public ChampionshipGameInfo() {
        super(GameInfo.GameType.CHAMPIONSHIP);
    }

    public boolean isFirstTrack() {
        return this.mTrackIndex == 0;
    }

    public boolean isLastTrack() {
        return this.mTrackIndex == this.mChampionship.getTracks().size - 1;
    }

    public void selectNextTrack() {
        Assert.check(!this.isLastTrack(), "Can't select past the last track", new Object[0]);
        ++this.mTrackIndex;
    }

    public Championship getChampionship() {
        return this.mChampionship;
    }

    @Override
    public Track getTrack() {
        return this.mChampionship.getTracks().get(this.mTrackIndex);
    }

    public static class Builder
    extends GameInfo.Builder<ChampionshipGameInfo> {
        private Championship mChampionship;

        public Builder(Array<VehicleDef> vehicleDefs, GameConfig gameConfig) {
            super(vehicleDefs, gameConfig);
        }

        public void setChampionship(Championship championship) {
            this.mChampionship = championship;
            this.mGameConfig.championship = this.mChampionship.getId();
            this.mGameConfig.flush(GameConfig.ConfigGroup.OTHER);
        }

        @Override
        public ChampionshipGameInfo build() {
            ChampionshipGameInfo gameInfo = new ChampionshipGameInfo();
            gameInfo.mChampionship = this.mChampionship;
            this.createEntrants(gameInfo);
            return gameInfo;
        }
    }
}

