/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.MapObjectWalker;
import com.agateau.pixelwheels.map.MapUtils;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class RectangleMapObjectWalker
implements MapObjectWalker {
    private MapObject mMapObject;

    @Override
    public void setMapObject(MapObject object) {
        this.mMapObject = object;
    }

    @Override
    public void walk(float stepWidth, float stepHeight, MapObjectWalker.WalkFunction function) {
        Vector2 vector2 = new Vector2();
        Rectangle rectangle = ((RectangleMapObject)this.mMapObject).getRectangle();
        float angle = MapUtils.getObjectRotation(this.mMapObject);
        float originX = rectangle.getX();
        float originY = rectangle.getY() + rectangle.getHeight();
        for (float y = -rectangle.getHeight() + stepHeight / 2.0f; y < 0.0f; y += stepHeight) {
            for (float x = stepWidth / 2.0f; x < rectangle.getWidth(); x += stepWidth) {
                vector2.set(x, y).rotate(angle).add(originX, originY);
                function.walk(vector2.x, vector2.y, 0.0f);
            }
        }
    }
}

