/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.badlogic.gdx.math.Vector2;

class Warper {
    float[] srcX = new float[4];
    float[] srcY = new float[4];
    float[] dstX = new float[4];
    float[] dstY = new float[4];
    float[] srcMat = new float[16];
    float[] dstMat = new float[16];
    float[] warpMat = new float[16];
    boolean dirty;
    private final Vector2 mOutput = new Vector2();

    public Warper() {
        this.setIdentity();
    }

    public void setIdentity() {
        this.setSource(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setDestination(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.computeWarp();
    }

    public void setSource(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.srcX[0] = x0;
        this.srcY[0] = y0;
        this.srcX[1] = x1;
        this.srcY[1] = y1;
        this.srcX[2] = x2;
        this.srcY[2] = y2;
        this.srcX[3] = x3;
        this.srcY[3] = y3;
        this.dirty = true;
    }

    public void setDestination(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.dstX[0] = x0;
        this.dstY[0] = y0;
        this.dstX[1] = x1;
        this.dstY[1] = y1;
        this.dstX[2] = x2;
        this.dstY[2] = y2;
        this.dstX[3] = x3;
        this.dstY[3] = y3;
        this.dirty = true;
    }

    public void computeWarp() {
        this.computeQuadToSquare(this.srcX[0], this.srcY[0], this.srcX[1], this.srcY[1], this.srcX[2], this.srcY[2], this.srcX[3], this.srcY[3], this.srcMat);
        this.computeSquareToQuad(this.dstX[0], this.dstY[0], this.dstX[1], this.dstY[1], this.dstX[2], this.dstY[2], this.dstX[3], this.dstY[3], this.dstMat);
        this.multMats(this.srcMat, this.dstMat, this.warpMat);
        this.dirty = false;
    }

    public void multMats(float[] srcMat, float[] dstMat, float[] resMat) {
        for (int r = 0; r < 4; ++r) {
            int ri = r * 4;
            for (int c = 0; c < 4; ++c) {
                resMat[ri + c] = srcMat[ri] * dstMat[c] + srcMat[ri + 1] * dstMat[c + 4] + srcMat[ri + 2] * dstMat[c + 8] + srcMat[ri + 3] * dstMat[c + 12];
            }
        }
    }

    public void computeSquareToQuad(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, float[] mat) {
        float dx1 = x1 - x2;
        float dy1 = y1 - y2;
        float dx2 = x3 - x2;
        float dy2 = y3 - y2;
        float sx = x0 - x1 + x2 - x3;
        float sy = y0 - y1 + y2 - y3;
        float g = (sx * dy2 - dx2 * sy) / (dx1 * dy2 - dx2 * dy1);
        float h = (dx1 * sy - sx * dy1) / (dx1 * dy2 - dx2 * dy1);
        float a = x1 - x0 + g * x1;
        float b = x3 - x0 + h * x3;
        float c = x0;
        float d = y1 - y0 + g * y1;
        float e = y3 - y0 + h * y3;
        float f = y0;
        mat[0] = a;
        mat[1] = d;
        mat[2] = 0.0f;
        mat[3] = g;
        mat[4] = b;
        mat[5] = e;
        mat[6] = 0.0f;
        mat[7] = h;
        mat[8] = 0.0f;
        mat[9] = 0.0f;
        mat[10] = 1.0f;
        mat[11] = 0.0f;
        mat[12] = c;
        mat[13] = f;
        mat[14] = 0.0f;
        mat[15] = 1.0f;
    }

    public void computeQuadToSquare(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, float[] mat) {
        this.computeSquareToQuad(x0, y0, x1, y1, x2, y2, x3, y3, mat);
        float a = mat[0];
        float d = mat[1];
        float g = mat[3];
        float b = mat[4];
        float e = mat[5];
        float h = mat[7];
        float c = mat[12];
        float f = mat[13];
        float A = e - f * h;
        float B2 = c * h - b;
        float C = b * f - c * e;
        float D2 = f * g - d;
        float E = a - c * g;
        float F2 = c * d - a * f;
        float G = d * h - e * g;
        float H = b * g - a * h;
        float I2 = a * e - b * d;
        float idet = 1.0f / (a * A + b * D2 + c * G);
        mat[0] = A * idet;
        mat[1] = D2 * idet;
        mat[2] = 0.0f;
        mat[3] = G * idet;
        mat[4] = B2 * idet;
        mat[5] = E * idet;
        mat[6] = 0.0f;
        mat[7] = H * idet;
        mat[8] = 0.0f;
        mat[9] = 0.0f;
        mat[10] = 1.0f;
        mat[11] = 0.0f;
        mat[12] = C * idet;
        mat[13] = F2 * idet;
        mat[14] = 0.0f;
        mat[15] = I2 * idet;
    }

    public Vector2 warp(float srcX, float srcY) {
        if (this.dirty) {
            this.computeWarp();
        }
        Warper.warp(this.warpMat, srcX, srcY, this.mOutput);
        return this.mOutput;
    }

    private static void warp(float[] mat, float srcX, float srcY, Vector2 output) {
        float result0 = srcX * mat[0] + srcY * mat[4] + mat[12];
        float result1 = srcX * mat[1] + srcY * mat[5] + mat[13];
        float result3 = srcX * mat[3] + srcY * mat[7] + mat[15];
        output.set(result0 / result3, result1 / result3);
    }
}

