/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.BodyIdentifier;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.EngineSoundPlayer;
import com.agateau.pixelwheels.sound.SoundAtlas;
import com.agateau.pixelwheels.sound.SoundPlayer;
import com.agateau.pixelwheels.sound.SoundSettings;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

class AudioComponent
implements Racer.Component,
Disposable,
Collidable {
    private static final float FULL_VOLUME_DRIFT_DURATION = 0.6f;
    private static final float MIN_IMPACT_SPEED = 3.0f;
    private static final float MIN_COLLISION_PITCH = 0.1f;
    private static final float MAX_COLLISION_PITCH = 4.0f;
    private static final float ICE_DRIFT_PITCH = 0.5f;
    private final AudioManager mAudioManager;
    private final EngineSoundPlayer mEngineSoundPlayer;
    private final Racer mRacer;
    private final SoundPlayer mDriftingSoundPlayer;
    private final SoundPlayer mTurboSoundPlayer;
    private final SoundPlayer mCollisionSoundPlayer;
    private final SoundPlayer mSplashSoundPlayer;
    private final Array<SoundPlayer> mSoundPlayers = new Array();
    private float mDriftDuration = 0.0f;
    private boolean mTurboTriggered = false;
    private boolean mJustCollided = false;

    public AudioComponent(SoundAtlas atlas, AudioManager audioManager, Racer racer) {
        this.mAudioManager = audioManager;
        this.mEngineSoundPlayer = racer.getEntrant().isPlayer() ? new EngineSoundPlayer(atlas, audioManager) : null;
        this.mDriftingSoundPlayer = audioManager.createSoundPlayer(atlas.get("drifting"));
        this.mTurboSoundPlayer = audioManager.createSoundPlayer(atlas.get("turbo"));
        this.mCollisionSoundPlayer = audioManager.createSoundPlayer(atlas.get("collision"));
        this.mSplashSoundPlayer = audioManager.createSoundPlayer(atlas.get("splash"));
        this.mSoundPlayers.addAll((SoundPlayer[])new SoundPlayer[]{this.mDriftingSoundPlayer, this.mTurboSoundPlayer, this.mCollisionSoundPlayer});
        this.mRacer = racer;
    }

    public AudioManager getAudioManager() {
        return this.mAudioManager;
    }

    @Override
    public void act(float delta) {
        this.mDriftDuration = this.mRacer.getVehicle().isDrifting() || this.mRacer.getVehicle().isIceDrifting() ? (this.mDriftDuration += delta) : 0.0f;
    }

    public void render(AudioClipper clipper) {
        float speed = this.mRacer.getVehicle().getSpeed();
        float normSpeed = MathUtils.clamp(speed / 50.0f, 0.0f, 1.0f);
        float maxVolume = SoundSettings.instance.engineVolume * clipper.clip(this.mRacer);
        if (this.mEngineSoundPlayer != null) {
            this.mEngineSoundPlayer.play(normSpeed, maxVolume);
        }
        if (this.mDriftDuration > 0.0f) {
            float volume = MathUtils.clamp(this.mDriftDuration / 0.6f, 0.0f, 1.0f) * maxVolume;
            this.mDriftingSoundPlayer.setPitch(this.mRacer.getVehicle().isIceDrifting() ? 0.5f : 1.0f);
            this.mDriftingSoundPlayer.setVolume(volume * SoundSettings.instance.driftVolume);
            if (!this.mDriftingSoundPlayer.isLooping()) {
                this.mDriftingSoundPlayer.loop();
            }
        } else {
            this.mDriftingSoundPlayer.stop();
        }
        if (this.mTurboTriggered) {
            this.mTurboSoundPlayer.setVolume(maxVolume * SoundSettings.instance.turboVolume);
            this.mTurboSoundPlayer.play();
            this.mTurboTriggered = false;
        }
        if (this.mJustCollided) {
            this.mCollisionSoundPlayer.setVolume(maxVolume);
            float pitch = MathUtils.random(0.1f, 4.0f);
            this.mCollisionSoundPlayer.setPitch(pitch);
            if (!this.mCollisionSoundPlayer.isLooping()) {
                this.mCollisionSoundPlayer.loop();
            }
            this.mJustCollided = false;
        } else {
            this.mCollisionSoundPlayer.stop();
        }
        if (this.mRacer.getVehicle().isOnWater()) {
            this.mSplashSoundPlayer.setVolume(normSpeed * maxVolume);
            if (!this.mSplashSoundPlayer.isLooping()) {
                this.mSplashSoundPlayer.loop();
            }
        } else {
            this.mSplashSoundPlayer.stop();
        }
    }

    public void triggerTurbo() {
        this.mTurboTriggered = true;
    }

    private void onCollision() {
        if (this.mRacer.getVehicle().getSpeed() > 3.0f) {
            this.mJustCollided = true;
        }
    }

    @Override
    public void dispose() {
        if (this.mEngineSoundPlayer != null) {
            this.mEngineSoundPlayer.stop();
        }
        for (SoundPlayer soundPlayer : this.mSoundPlayers) {
            soundPlayer.stop();
        }
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
        Body otherBody = otherFixture.getBody();
        if (BodyIdentifier.isVehicle(otherBody) || BodyIdentifier.isWall(otherBody)) {
            this.onCollision();
        }
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
    }
}

