/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Renderer;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffectPool;
import com.badlogic.gdx.math.Vector2;

public class DisruptedComponent
implements Racer.Component,
Renderer {
    private static final float DURATION = 1.5f;
    private final Assets mAssets;
    private final Racer mRacer;
    private boolean mActive = false;
    private float mRemainingDuration = 0.0f;
    private ParticleEffectPool.PooledEffect mSmokeEffect;
    private final Vector2 mTmp = new Vector2();

    public DisruptedComponent(Assets assets, Racer racer) {
        this.mAssets = assets;
        this.mRacer = racer;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public float getNormalizedDuration() {
        return this.mRemainingDuration / 1.5f;
    }

    public void start() {
        this.mRemainingDuration = 1.5f;
        if (this.mActive) {
            return;
        }
        this.mActive = true;
        this.mSmokeEffect = (ParticleEffectPool.PooledEffect)this.mAssets.smokeEffectPool.obtain();
        this.mRacer.getVehicleRenderer().addRenderer(this);
    }

    @Override
    public void act(float delta) {
        if (this.mSmokeEffect != null) {
            this.mSmokeEffect.update(delta);
            if (this.mActive) {
                if (this.mSmokeEffect.isComplete()) {
                    this.mSmokeEffect.start();
                }
            } else if (this.mSmokeEffect.isComplete()) {
                this.mSmokeEffect.free();
                this.mRacer.getVehicleRenderer().removeRenderer(this);
                this.mSmokeEffect = null;
            }
        }
        if (this.mActive) {
            this.mRemainingDuration -= delta;
            if (this.mRemainingDuration <= 0.0f) {
                this.mRemainingDuration = 0.0f;
                this.mActive = false;
            }
        }
    }

    @Override
    public void drawToCell(Batch batch, float centerX, float centerY) {
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel) {
        if (zLevel != ZLevel.FLYING_HIGH) {
            return;
        }
        if (this.mSmokeEffect == null) {
            return;
        }
        Vehicle vehicle = this.mRacer.getVehicle();
        this.mTmp.set(vehicle.getWidth() / 4.0f, 0.0f).rotateDeg(vehicle.getAngle()).add(vehicle.getX(), vehicle.getY());
        this.mSmokeEffect.setPosition(this.mTmp.x, this.mTmp.y);
        this.mSmokeEffect.draw(batch);
    }
}

