/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.rewards;

import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.rewards.Reward;
import com.agateau.pixelwheels.rewards.RewardRule;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RewardManager {
    private final GameStats mGameStats;
    private final Map<Reward, RewardRule> mRules = new HashMap<Reward, RewardRule>();
    private final UnlockedRewards mUnlockedRewards = new UnlockedRewards();
    public static final RewardRule ALWAYS_UNLOCKED = new RewardRule(){

        @Override
        public boolean hasBeenUnlocked(GameStats gameStats) {
            return true;
        }

        @Override
        public String getUnlockText(GameStats gameStats) {
            return "";
        }
    };

    public void markAllUnlockedRewardsSeen() {
        this.mUnlockedRewards.markAllSeen();
    }

    public Set<Reward> getUnseenUnlockedRewards() {
        return this.mUnlockedRewards.getUnseen();
    }

    public RewardManager(GameStats gameStats) {
        this.mGameStats = gameStats;
        this.mGameStats.setListener(this.mUnlockedRewards::scheduleUpdate);
    }

    public boolean isTrackUnlocked(Track track) {
        Championship championship = track.getChampionship();
        return this.isChampionshipUnlocked(championship);
    }

    public boolean isChampionshipUnlocked(Championship championship) {
        return this.getUnlockedRewards().contains(Reward.get(championship));
    }

    public boolean isVehicleUnlocked(VehicleDef vehicleDef) {
        return this.getUnlockedRewards().contains(Reward.get(vehicleDef));
    }

    public Set<Reward> getUnlockedRewards() {
        return this.mUnlockedRewards.get();
    }

    public void addRule(Reward reward, RewardRule rule) {
        this.mRules.put(reward, rule);
    }

    public boolean hasRuleForReward(Reward reward) {
        return this.mRules.containsKey(reward);
    }

    public String getUnlockText(Track track) {
        Championship championship = track.getChampionship();
        return this.getUnlockText(Reward.get(championship));
    }

    public String getUnlockText(Championship championship) {
        return this.getUnlockText(Reward.get(championship));
    }

    public String getUnlockText(VehicleDef vehicle) {
        return this.getUnlockText(Reward.get(vehicle));
    }

    private String getUnlockText(Reward reward) {
        if (this.mUnlockedRewards.get().contains(reward)) {
            return "";
        }
        return this.mRules.get(reward).getUnlockText(this.mGameStats);
    }

    private class UnlockedRewards {
        private final Set<Reward> mRewards = new HashSet<Reward>();
        private final Set<Reward> mUnseenRewards = new HashSet<Reward>();
        private boolean mNeedsUpdate = true;

        private UnlockedRewards() {
        }

        Set<Reward> get() {
            if (this.mNeedsUpdate) {
                this.update();
            }
            return this.mRewards;
        }

        Set<Reward> getUnseen() {
            if (this.mNeedsUpdate) {
                this.update();
            }
            return new HashSet<Reward>(this.mUnseenRewards);
        }

        void markAllSeen() {
            if (this.mNeedsUpdate) {
                this.update();
            }
            this.mUnseenRewards.clear();
        }

        void scheduleUpdate() {
            this.mNeedsUpdate = true;
        }

        private void update() {
            this.mNeedsUpdate = false;
            for (Map.Entry rule : RewardManager.this.mRules.entrySet()) {
                Reward reward = (Reward)rule.getKey();
                if (this.mRewards.contains(reward) || !((RewardRule)rule.getValue()).hasBeenUnlocked(RewardManager.this.mGameStats)) continue;
                this.mRewards.add(reward);
                this.mUnseenRewards.add(reward);
            }
        }
    }
}

