/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.utils.UiUtils;
import com.agateau.ui.StageScreen;
import com.agateau.ui.UiAssets;
import com.agateau.ui.UiInputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public abstract class PwStageScreen
extends StageScreen {
    public static final int WIDTH = 960;
    public static final int HEIGHT = 540;

    public PwStageScreen(UiAssets uiAssets) {
        super(new ScalingViewport(Scaling.fit, 960.0f, 540.0f));
        Image image = new Image();
        image.setDrawable(new TiledDrawable(uiAssets.background));
        image.setFillParent(true);
        this.getStage().addActor(image);
        if (Debug.instance.logUiActivities) {
            this.setupUiLogging();
        }
    }

    private void setupUiLogging() {
        this.prependInputProcessor(new InputAdapter(){
            private final StringBuilder mStringBuilder = new StringBuilder(200);
            private final Vector2 mTmp = new Vector2();

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                Stage stage = PwStageScreen.this.getStage();
                Viewport viewport = stage.getViewport();
                NLog.d("viewport: x=%d y=%d w=%d h=%d\ngutter: left=%d right=%d top=%d bottom=%d", viewport.getScreenX(), viewport.getScreenY(), viewport.getScreenWidth(), viewport.getScreenHeight(), viewport.getLeftGutterWidth(), viewport.getRightGutterWidth(), viewport.getTopGutterHeight(), viewport.getBottomGutterHeight());
                NLog.d("screenX=%d screenY=%d (pointer=%d button=%d)", screenX, screenY, pointer, button);
                this.mTmp.set(screenX, screenY);
                stage.screenToStageCoordinates(this.mTmp);
                NLog.d("stageX=%f stageY=%f", Float.valueOf(this.mTmp.x), Float.valueOf(this.mTmp.y));
                Actor hitActor = stage.hit(this.mTmp.x, this.mTmp.y, false);
                Actor touchableHitActor = stage.hit(this.mTmp.x, this.mTmp.y, true);
                NLog.d("Actor at coord: %s (touchable: %s)", hitActor, touchableHitActor);
                return false;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                NLog.d("x=%d y=%d (pointer=%d button=%d)", screenX, screenY, pointer, button);
                this.mStringBuilder.setLength(0);
                this.mStringBuilder.append("\n# Scene dump start\n");
                UiUtils.dumpStage(this.mStringBuilder, PwStageScreen.this.getStage());
                this.mStringBuilder.append("# Scene dump stop");
                NLog.d(this.mStringBuilder.toString(), new Object[0]);
                return false;
            }
        });
    }

    @Override
    public boolean isBackKeyPressed() {
        return UiInputMapper.getInstance().isKeyJustPressed(VirtualKey.BACK);
    }

    public static float getUnitsPerPixel() {
        return Math.max(960.0f / (float)Gdx.graphics.getWidth(), 540.0f / (float)Gdx.graphics.getHeight());
    }
}

