/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.rewards.Reward;
import com.agateau.pixelwheels.screens.NavStageScreen;
import com.agateau.pixelwheels.screens.VehicleActor;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

public class UnlockedRewardScreen
extends NavStageScreen {
    private final PwGame mGame;
    private final Reward mReward;
    private final NavStageScreen.NextListener mNextListener;

    public UnlockedRewardScreen(PwGame game, Reward reward, NavStageScreen.NextListener nextListener) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mReward = reward;
        this.mNextListener = nextListener;
        this.setupUi();
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                UnlockedRewardScreen.this.mGame.replaceScreen(new UnlockedRewardScreen(UnlockedRewardScreen.this.mGame, UnlockedRewardScreen.this.mReward, UnlockedRewardScreen.this.mNextListener));
            }
        };
    }

    public static UnlockedRewardScreen createDebugScreen(PwGame game) {
        Reward reward;
        String[] tokens = Constants.DEBUG_SCREEN.split(":");
        Assert.check(tokens.length == 2, "Expected one `:` in PW_DEBUG_SCREEN", new Object[0]);
        String id = tokens[1];
        switch (tokens[0]) {
            case "UnlockedVehicle": {
                reward = Reward.get(game.getAssets().findVehicleDefById(id));
                break;
            }
            case "UnlockedChampionship": {
                reward = Reward.get(game.getAssets().findChampionshipById(id));
                break;
            }
            default: {
                throw new RuntimeException("Invalid value for reward type");
            }
        }
        return new UnlockedRewardScreen(game, reward, new NavStageScreen.NextListener(){

            @Override
            public void onNextPressed() {
            }
        });
    }

    private void setupUi() {
        Assets assets = this.mGame.getAssets();
        boolean isVehicle = this.mReward.prize instanceof VehicleDef;
        UiBuilder builder = new UiBuilder(assets.atlas, assets.ui.skin);
        VehicleActor.register(builder, assets);
        if (isVehicle) {
            builder.defineVariable("vehicle");
        }
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/unlockedreward.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.setupNextButton((Button)builder.getActor("nextButton"));
        this.setNavListener(this.mNextListener);
        if (isVehicle) {
            this.setupVehicleReward(builder, (VehicleDef)this.mReward.prize);
        } else if (this.mReward.prize instanceof Championship) {
            this.setupChampionshipReward(builder, (Championship)this.mReward.prize);
        } else {
            throw new RuntimeException("Don't know how to show reward for " + this.mReward.prize);
        }
    }

    private void setupVehicleReward(UiBuilder builder, VehicleDef vehicleDef) {
        VehicleActor vehicle = (VehicleActor)builder.getActor("vehicle");
        vehicle.setVehicleDef(vehicleDef);
        this.setupRewardDetails(builder, Translator.tr("New vehicle unlocked!"), vehicleDef.getName());
    }

    private void setupChampionshipReward(UiBuilder builder, Championship championship) {
        Image image = (Image)builder.getActor("championshipImage");
        image.setDrawable(new TextureRegionDrawable(this.mGame.getAssets().getChampionshipRegion(championship)));
        image.pack();
        image.setOrigin(1);
        this.setupRewardDetails(builder, Translator.tr("New championship unlocked!"), championship.getName());
    }

    private void setupRewardDetails(UiBuilder builder, String title, String rewardName) {
        Label titleLabel = (Label)builder.getActor("titleLabel");
        Label rewardLabel = (Label)builder.getActor("rewardLabel");
        titleLabel.setText(title);
        titleLabel.pack();
        rewardLabel.setText(rewardName);
        rewardLabel.pack();
    }
}

