/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.sound;

import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.SoundAtlas;
import com.agateau.pixelwheels.sound.SoundPlayer;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;
import java.util.Locale;

public class EngineSoundPlayer {
    public static final float MIN_PITCH = 0.5f;
    public static final float MAX_PITCH = 2.0f;
    private float mPitch = 0.5f;
    private final Array<SoundPlayer> mSoundPlayers = new Array();

    public int getSoundCount() {
        return this.mSoundPlayers.size;
    }

    public float getSoundVolume(int idx) {
        return this.mSoundPlayers.get(idx).getVolume();
    }

    public float getPitch() {
        return this.mPitch;
    }

    public EngineSoundPlayer(SoundAtlas atlas, AudioManager audioManager) {
        String name;
        int i = 0;
        while (atlas.contains(name = String.format(Locale.US, "engine-%d", i))) {
            Sound sound = atlas.get(name);
            this.mSoundPlayers.add(audioManager.createSoundPlayer(sound));
            ++i;
        }
    }

    public void play(float speed, float maxVolume) {
        this.mPitch = Interpolation.pow2Out.apply(0.5f, 2.0f, speed);
        float idx = speed * (float)(this.mSoundPlayers.size - 1);
        for (int i = 0; i < this.mSoundPlayers.size; ++i) {
            float di = Math.abs((float)i - idx);
            float volume = Math.max(1.0f - di, 0.0f) * maxVolume;
            SoundPlayer player = this.mSoundPlayers.get(i);
            player.setVolume(volume);
            player.setPitch(this.mPitch);
            if ((double)volume > 0.01) {
                if (player.isLooping()) continue;
                player.loop();
                continue;
            }
            player.stop();
        }
    }

    public void stop() {
        for (SoundPlayer player : this.mSoundPlayers) {
            player.stop();
        }
    }
}

