/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.vehicledef;

import com.agateau.pixelwheels.vehicledef.AxleDef;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.utils.XmlReader;

public class VehicleIO {
    public static VehicleDef get(String id) {
        String fileName = "vehicles/" + id + ".xml";
        FileHandle handle = FileUtils.assets(fileName);
        if (!handle.exists()) {
            throw new RuntimeException("No such file " + fileName);
        }
        XmlReader.Element root = FileUtils.parseXml(handle);
        if (root == null) {
            throw new RuntimeException("Error loading vehicle from " + fileName);
        }
        try {
            return VehicleIO.get(root, id);
        }
        catch (Exception e) {
            NLog.e("Error loading vehicle from %s: %s", fileName, e);
            e.printStackTrace();
            throw new RuntimeException("Error loading vehicle from " + fileName);
        }
    }

    public static VehicleDef get(XmlReader.Element root, String id) {
        VehicleDef data = new VehicleDef(id, root.getAttribute("name"));
        data.speed = root.getFloatAttribute("speed");
        float width = root.getFloatAttribute("height");
        float height = root.getFloatAttribute("width");
        XmlReader.Element mainElement = root.getChildByName("main");
        data.mainImage = mainElement.getAttribute("image");
        XmlReader.Element shapesElement = root.getChildByName("shapes");
        int n = shapesElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            XmlReader.Element element = shapesElement.getChild(i);
            data.shapes.add(VehicleIO.loadShape(element, width, height));
        }
        if (data.shapes.size == 0) {
            throw new RuntimeException("No shapes defined in vehicle " + id);
        }
        for (XmlReader.Element element : root.getChildrenByName("axle")) {
            AxleDef axle = new AxleDef();
            axle.width = element.getFloatAttribute("width");
            axle.y = element.getFloatAttribute("y");
            axle.steer = element.getFloatAttribute("steer", 0.0f);
            axle.drive = element.getFloatAttribute("drive", 1.0f);
            axle.drift = element.getBooleanAttribute("drift", true);
            axle.tireSize = AxleDef.TireSize.valueOf(element.getAttribute("tireSize", "NORMAL"));
            data.axles.add(axle);
        }
        return data;
    }

    private static Shape2D loadShape(XmlReader.Element element, float vehicleWidth, float vehicleHeight) {
        String type = element.getName();
        if (type.equals("octogon")) {
            float width = element.getFloatAttribute("height");
            float height = element.getFloatAttribute("width");
            float x = element.getFloatAttribute("y", (vehicleWidth - width) / 2.0f);
            float y = element.getFloatAttribute("x", (vehicleHeight - height) / 2.0f);
            float corner = element.getFloatAttribute("corner", 0.0f);
            Polygon polygon = new Polygon();
            polygon.setVertices(new float[]{width / 2.0f - corner, -height / 2.0f, width / 2.0f, -height / 2.0f + corner, width / 2.0f, height / 2.0f - corner, width / 2.0f - corner, height / 2.0f, -width / 2.0f + corner, height / 2.0f, -width / 2.0f, height / 2.0f - corner, -width / 2.0f, -height / 2.0f + corner, -width / 2.0f + corner, -height / 2.0f});
            polygon.translate(x - (vehicleWidth - width) / 2.0f, y - (vehicleHeight - height) / 2.0f);
            return polygon;
        }
        if (type.equals("trapezoid")) {
            float bottomHeight = element.getFloatAttribute("bottomWidth");
            float topHeight = element.getFloatAttribute("topWidth");
            float height = Math.max(bottomHeight, topHeight);
            float width = element.getFloatAttribute("height");
            float x = element.getFloatAttribute("y", (vehicleWidth - width) / 2.0f);
            float y = element.getFloatAttribute("x", (vehicleHeight - height) / 2.0f);
            Polygon polygon = new Polygon();
            polygon.setVertices(new float[]{width / 2.0f, topHeight / 2.0f, -width / 2.0f, bottomHeight / 2.0f, -width / 2.0f, -bottomHeight / 2.0f, width / 2.0f, -topHeight / 2.0f});
            polygon.translate(x - (vehicleWidth - width) / 2.0f, y - (vehicleHeight - height) / 2.0f);
            return polygon;
        }
        throw new RuntimeException("Unknown shape type: " + element);
    }
}

