/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.animscript;

import com.agateau.ui.DimensionParser;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.animscript.Instruction;
import com.agateau.ui.animscript.InstructionDefinition;
import com.agateau.ui.animscript.RepeatInstruction;
import com.badlogic.gdx.utils.Array;
import java.io.IOException;
import java.io.StreamTokenizer;

public class RepeatInstructionDefinition
implements InstructionDefinition {
    private final AnimScriptLoader mLoader;

    RepeatInstructionDefinition(AnimScriptLoader loader) {
        this.mLoader = loader;
    }

    @Override
    public Instruction parse(StreamTokenizer tokenizer, DimensionParser dimParser) throws AnimScriptLoader.SyntaxException {
        int count = this.parseCount(tokenizer);
        Array<Instruction> lst = this.mLoader.tokenize(tokenizer, "end", dimParser);
        return new RepeatInstruction(lst, count);
    }

    private int parseCount(StreamTokenizer tokenizer) throws AnimScriptLoader.SyntaxException {
        try {
            tokenizer.nextToken();
        }
        catch (IOException e) {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "Missing count argument");
        }
        if (tokenizer.ttype == 10) {
            return 0;
        }
        if (tokenizer.ttype == -2) {
            return (int)tokenizer.nval;
        }
        throw new AnimScriptLoader.SyntaxException(tokenizer, "Error in repeat instruction: '" + tokenizer.sval + "' is not a valid repeat count");
    }
}

