/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

public abstract class CircularArray<T> {
    private final T[] mItems;
    private int mBegin = 0;
    private int mEnd = 0;

    public CircularArray(int size) {
        this.mItems = new Object[size + 1];
    }

    public T get(int index) {
        return this.mItems[index];
    }

    public int getBeginIndex() {
        return this.mBegin;
    }

    public int getEndIndex() {
        return this.mEnd;
    }

    public int getNextIndex(int idx) {
        return (idx + 1) % this.mItems.length;
    }

    public T add() {
        T element = this.mItems[this.mEnd];
        if (element == null) {
            this.mItems[this.mEnd] = element = this.createInstance();
        }
        this.mEnd = this.getNextIndex(this.mEnd);
        if (this.mBegin == this.mEnd) {
            this.mBegin = this.getNextIndex(this.mBegin);
        }
        return element;
    }

    protected abstract T createInstance();
}

