/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthListUI
extends BasicListUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    private boolean useUIBorder;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthListUI();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintListBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        synthContext.dispose();
        this.paint(graphics, jComponent);
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintListBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.list.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JList)propertyChangeEvent.getSource());
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults() {
        if (this.list.getCellRenderer() == null || this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(new SynthListCellRenderer());
        }
        this.updateStyle(this.list);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this.list, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(512);
            Color color2 = this.list.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.list.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
                this.list.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            this.useListColors = this.style.getBoolean(synthContext, "List.rendererUseListColors", true);
            this.useUIBorder = this.style.getBoolean(synthContext, "List.rendererUseUIBorder", true);
            int n = this.style.getInt(synthContext, "List.cellHeight", -1);
            if (n != -1) {
                this.list.setFixedCellHeight(n);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        SynthContext synthContext = this.getContext(this.list, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private class SynthListCellRenderer
    extends DefaultListCellRenderer.UIResource {
        private SynthListCellRenderer() {
        }

        @Override
        public String getName() {
            return "List.cellRenderer";
        }

        @Override
        public void setBorder(Border border) {
            if (SynthListUI.this.useUIBorder || border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!SynthListUI.this.useListColors && (bl || bl2)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl, bl2, jList.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

