/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.bonus.BonusAdapter;
import com.agateau.pixelwheels.bonus.Missile;
import com.agateau.pixelwheels.racer.Racer;
import com.badlogic.gdx.utils.Pool;

public class MissileBonus
extends BonusAdapter
implements Pool.Poolable {
    private Missile mMissile;
    private boolean mTriggered;
    private boolean mOwnerHit;

    public MissileBonus() {
        this.reset();
    }

    @Override
    public void reset() {
        this.mTriggered = false;
        this.mOwnerHit = false;
    }

    @Override
    public void onPicked(Racer racer) {
        super.onPicked(racer);
        this.mMissile = Missile.create(this.mAssets, this.mGameWorld, this.mAudioManager, this.mRacer);
    }

    @Override
    public void onOwnerHit() {
        this.mOwnerHit = true;
    }

    @Override
    public void trigger() {
        this.mTriggered = true;
    }

    @Override
    public void act(float delta) {
        if (this.mTriggered) {
            this.mMissile.shoot();
            this.resetBonus();
        }
        if (this.mOwnerHit) {
            this.mMissile.remove();
            this.resetBonus();
        }
    }

    @Override
    public void aiAct(float delta) {
        if (this.mMissile.hasTarget()) {
            this.trigger();
        }
    }

    private void resetBonus() {
        this.free();
        this.mRacer.resetBonus();
    }
}

