/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.desktop;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.desktop.DesktopLogExporter;
import com.agateau.pixelwheels.desktop.DesktopPlatformUtilsImpl;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.utils.FileUtils;
import com.agateau.utils.PlatformUtils;
import com.agateau.utils.log.LogFilePrinter;
import com.agateau.utils.log.NLog;
import com.agateau.utils.log.SystemErrPrinter;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import java.io.File;
import java.util.Locale;

public class DesktopLauncher {
    public static void main(String[] arg) {
        FileUtils.appName = "pixelwheels";
        DesktopLauncher.migrateLegacyConfigFile();
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(960, 540);
        config.setWindowIcon("desktop-icon/desktop-icon.png");
        config.setTitle("Pixel Wheels");
        config.setPreferencesConfig(FileUtils.getDesktopConfigDir(), Files.FileType.Absolute);
        config.useVsync(true);
        PwGame game = new PwGame();
        DesktopLauncher.setupLogging(game);
        PlatformUtils.setup(new DesktopPlatformUtilsImpl());
        new Lwjgl3Application(game, config);
    }

    private static void setupLogging(PwGame game) {
        String cacheDir = FileUtils.getDesktopCacheDir();
        File file = new File(cacheDir);
        if (!file.isDirectory() && !file.mkdirs()) {
            System.err.println(StringUtils.format("Can't create cache dir %s, won't be able to log to a file", cacheDir));
            return;
        }
        String logFilePath = cacheDir + File.separator + "pixelwheels.log";
        LogFilePrinter printer = new LogFilePrinter(logFilePath, 0x100000L);
        NLog.addPrinter(printer);
        NLog.addPrinter(new SystemErrPrinter());
        game.setLogExporter(new DesktopLogExporter(printer));
    }

    private static void migrateLegacyConfigFile() {
        FileHandle configFile = new FileHandle(FileUtils.getDesktopConfigDir() + File.separator + "pixelwheels.conf");
        if (configFile.exists()) {
            return;
        }
        FileHandle legacyConfigFile = new FileHandle(FileUtils.getDesktopLegacyConfigDir() + File.separator + "pixelwheels.conf");
        if (!legacyConfigFile.exists()) {
            return;
        }
        FileHandle configDir = configFile.parent();
        if (!configDir.exists() && !configDir.file().mkdirs()) {
            System.err.printf(Locale.US, "Failed to migrate %s: could not create %s\n", legacyConfigFile, configDir);
            return;
        }
        System.err.printf(Locale.US, "Migrating %s to %s\n", legacyConfigFile, configFile);
        legacyConfigFile.moveTo(configFile);
    }
}

