/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.desktop;

import com.agateau.utils.PlatformUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.IOException;
import java.util.ArrayList;

public class DesktopPlatformUtilsImpl
implements PlatformUtils.Impl {
    @Override
    public void openURI(String uri) {
        ArrayList<String> command = new ArrayList<String>();
        if (SharedLibraryLoader.isLinux) {
            command.add("xdg-open");
        } else if (SharedLibraryLoader.isWindows) {
            command.add("cmd.exe");
            command.add("/c");
            command.add("start");
            command.add("");
        } else if (SharedLibraryLoader.isMac) {
            command.add("open");
        }
        if (command.isEmpty()) {
            NLog.e("Don't know how to open URL %s on this OS", uri);
            return;
        }
        command.add(uri);
        NLog.i("Opening %s with '%s'", uri, command);
        try {
            new ProcessBuilder(command).start();
        }
        catch (IOException e) {
            NLog.e("Command failed: %s", e);
            return;
        }
        if (Gdx.graphics.isFullscreen()) {
            Lwjgl3Window window = ((Lwjgl3Graphics)Gdx.graphics).getWindow();
            window.iconifyWindow();
        }
    }
}

