/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.gameinput.DigitalSteering;
import com.agateau.pixelwheels.gameinput.GameInput;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.pixelwheels.racescreen.PieButton;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Array;

public class PieTouchInputHandler
implements GameInputHandler {
    private final GameInput mInput = new GameInput();
    private final DigitalSteering mSteer = new DigitalSteering();
    private PieButton mLeftButton;
    private PieButton mRightButton;
    private PieButton mBrakeButton;
    private PieButton mBonusButton;

    @Override
    public GameInput getGameInput() {
        this.mInput.braking = this.mBrakeButton.isPressed();
        this.mInput.accelerating = !this.mInput.braking;
        this.mInput.direction = this.mSteer.steer(this.mLeftButton.isPressed(), this.mRightButton.isPressed());
        this.mInput.triggeringBonus = this.mBonusButton.isPressed();
        return this.mInput;
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
    }

    @Override
    public void setBonus(Bonus bonus) {
        this.mBonusButton.setEnabled(bonus != null);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getTypeName() {
        return Translator.tr("Pie buttons");
    }

    @Override
    public void createHudButtons(Assets assets, Hud hud) {
        this.mLeftButton = new PieButton(assets, hud, "pie-left");
        this.mLeftButton.setSector(45, 90);
        this.mRightButton = new PieButton(assets, hud, "pie-right");
        this.mRightButton.setSector(0, 45);
        this.mBonusButton = new PieButton(assets, hud, "pie-action");
        this.mBonusButton.setSector(90, 135);
        this.mBonusButton.setEnabled(false);
        this.mBrakeButton = new PieButton(assets, hud, "pie-brake");
        this.mBrakeButton.setSector(135, 180);
        AnchorGroup root = hud.getInputUiContainer();
        root.addPositionRule(this.mLeftButton, Anchor.BOTTOM_LEFT, root, Anchor.BOTTOM_LEFT);
        root.addPositionRule(this.mRightButton, Anchor.BOTTOM_LEFT, root, Anchor.BOTTOM_LEFT);
        root.addPositionRule(this.mBrakeButton, Anchor.BOTTOM_RIGHT, root, Anchor.BOTTOM_RIGHT);
        root.addPositionRule(this.mBonusButton, Anchor.BOTTOM_RIGHT, root, Anchor.BOTTOM_RIGHT);
    }

    public static class Factory
    implements GameInputHandlerFactory {
        final Array<GameInputHandler> mHandlers = new Array();

        Factory() {
            this.mHandlers.add(new PieTouchInputHandler());
        }

        @Override
        public String getId() {
            return "pie";
        }

        @Override
        public String getName() {
            return Translator.tr("Pie buttons");
        }

        @Override
        public Array<GameInputHandler> getAllHandlers() {
            return this.mHandlers;
        }
    }
}

