/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gamesetup;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.badlogic.gdx.utils.Array;

public class QuickRaceGameInfo
extends GameInfo {
    private Track mTrack;

    public QuickRaceGameInfo() {
        super(GameInfo.GameType.QUICK_RACE);
    }

    @Override
    public Track getTrack() {
        return this.mTrack;
    }

    public static class Builder
    extends GameInfo.Builder<QuickRaceGameInfo> {
        private Track mTrack;

        public Builder(Array<VehicleDef> vehicleDefs, GameConfig gameConfig) {
            super(vehicleDefs, gameConfig);
        }

        public void setTrack(Track track) {
            this.mTrack = track;
            this.mGameConfig.track = this.mTrack.getId();
            this.mGameConfig.flush(GameConfig.ConfigGroup.OTHER);
        }

        @Override
        public QuickRaceGameInfo build() {
            QuickRaceGameInfo gameInfo = new QuickRaceGameInfo();
            gameInfo.mTrack = this.mTrack;
            this.createEntrants(gameInfo);
            return gameInfo;
        }
    }
}

