/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.MapObjectWalker;
import com.agateau.pixelwheels.map.MapUtils;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Vector2;

class PolylineMapObjectWalker
implements MapObjectWalker {
    private MapObject mMapObject;
    private static final Vector2 sTmp = new Vector2();

    PolylineMapObjectWalker() {
    }

    @Override
    public void setMapObject(MapObject object) {
        this.mMapObject = object;
    }

    @Override
    public void walk(float stepWidth, float stepHeight, MapObjectWalker.WalkFunction function) {
        Vector2 origin = new Vector2();
        Vector2 v1 = new Vector2();
        Vector2 v2 = new Vector2();
        Polyline polyline = ((PolylineMapObject)this.mMapObject).getPolyline();
        float angle = MapUtils.getObjectRotation(this.mMapObject);
        float[] vertices = polyline.getTransformedVertices();
        int count = vertices.length / 2;
        PolylineMapObjectWalker.readVector(origin, vertices, 0);
        v1.set(origin);
        for (int idx = 1; idx < count; ++idx) {
            PolylineMapObjectWalker.readVector(v2, vertices, idx);
            v2.sub(origin).rotateDeg(angle).add(origin);
            this.walkVector(v1, v2, stepWidth, function);
            v1.set(v2);
        }
    }

    private static void readVector(Vector2 vector, float[] vertices, int index) {
        vector.set(vertices[2 * index], vertices[2 * index + 1]);
    }

    private void walkVector(Vector2 v1, Vector2 v2, float stepSize, MapObjectWalker.WalkFunction function) {
        sTmp.set(v2).sub(v1);
        float distance = sTmp.len() - stepSize;
        float angle = sTmp.angleRad();
        int itemCount = MathUtils.floor(distance / stepSize);
        sTmp.nor().scl(stepSize);
        float dx = PolylineMapObjectWalker.sTmp.x;
        float dy = PolylineMapObjectWalker.sTmp.y;
        sTmp.set(v1).add(dx / 2.0f, dy / 2.0f);
        for (int i = 0; i <= itemCount; ++i) {
            function.walk(PolylineMapObjectWalker.sTmp.x, PolylineMapObjectWalker.sTmp.y, angle);
            sTmp.add(dx, dy);
        }
    }
}

