/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.BodyIdentifier;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.map.MaterialChecker;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.map.WaypointStore;
import com.agateau.pixelwheels.racer.Pilot;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.pixelwheels.utils.ClosestBodyFinder;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;

public class AIPilot
implements Pilot {
    private static final float MIN_NORMAL_SPEED = 2.0f;
    private static final float MAX_BLOCKED_DURATION = 1.0f;
    private static final float MAX_REVERSE_DURATION = 0.5f;
    private static final int MAX_FORWARD_WAYPOINTS = 2;
    private static final float AVOIDANCE_FACTOR = 2.0f;
    private final Vector2 mHalfWidth = new Vector2();
    private final Vector2 mTmpVector1 = new Vector2();
    private final Vector2 mTmpVector2 = new Vector2();
    private final GameWorld mGameWorld;
    private final Track mTrack;
    private final Racer mRacer;
    private final ClosestBodyFinder mClosestBodyFinder;
    private final MaterialChecker mMaterialChecker;
    private State mState = State.NORMAL;
    private float mBlockedDuration = 0.0f;
    private float mReverseDuration = 0.0f;
    private final Target mTarget = new Target();
    private final Target mNextTarget = new Target();
    private static final GameStats sDummyGameStats = new GameStats(){

        @Override
        public void setListener(GameStats.Listener listener) {
        }

        @Override
        public TrackStats getTrackStats(Difficulty difficulty, Track track) {
            return null;
        }

        @Override
        public int getBestChampionshipRank(Difficulty difficulty, Championship championship) {
            return 0;
        }

        @Override
        public void onChampionshipFinished(Difficulty difficulty, Championship championship, int rank) {
        }

        @Override
        public void recordEvent(GameStats.Event event) {
        }

        @Override
        public void recordIntEvent(GameStats.Event event, int value) {
        }

        @Override
        public int getEventCount(GameStats.Event event) {
            return 0;
        }

        @Override
        public void save() {
        }
    };

    public AIPilot(GameWorld gameWorld, Track track, Racer racer) {
        this.mGameWorld = gameWorld;
        this.mTrack = track;
        this.mRacer = racer;
        this.mClosestBodyFinder = new ClosestBodyFinder(body -> {
            if (BodyIdentifier.isStaticObstacle(body)) {
                return true;
            }
            return BodyIdentifier.isOtherVehicle(body, this.mRacer);
        });
        this.mMaterialChecker = new MaterialChecker(track);
    }

    Vector2 getTargetPosition() {
        return this.mTarget.position;
    }

    @Override
    public void act(float dt) {
        this.handleBonus(dt);
        switch (this.mState) {
            case NORMAL: {
                this.actNormal(dt);
                break;
            }
            case BLOCKED: {
                this.actBlocked(dt);
            }
        }
    }

    @Override
    public GameStats getGameStats() {
        return sDummyGameStats;
    }

    private void actNormal(float dt) {
        Vehicle vehicle = this.mRacer.getVehicle();
        this.mHalfWidth.set(0.0f, vehicle.getHeight() / 2.0f).rotateDeg(vehicle.getAngle());
        this.updateAcceleration();
        this.updateDirection();
        if (this.mState == State.BLOCKED) {
            return;
        }
        float speed = this.mRacer.getVehicle().getSpeed();
        if (this.mGameWorld.getState() == GameWorld.State.RUNNING && speed < 2.0f) {
            this.mBlockedDuration += dt;
            if (this.mBlockedDuration > 1.0f) {
                this.switchToBlocked();
            }
        } else {
            this.mBlockedDuration = 0.0f;
        }
    }

    private void switchToBlocked() {
        this.mState = State.BLOCKED;
        this.mReverseDuration = 0.0f;
    }

    private void actBlocked(float dt) {
        Vehicle vehicle = this.mRacer.getVehicle();
        vehicle.setAccelerating(false);
        vehicle.setBraking(true);
        vehicle.setDirection(0.0f);
        this.mReverseDuration += dt;
        if (this.mReverseDuration > 0.5f) {
            this.mState = State.NORMAL;
            this.mBlockedDuration = 0.0f;
        }
    }

    private void updateAcceleration() {
        Vehicle vehicle = this.mRacer.getVehicle();
        vehicle.setAccelerating(true);
        vehicle.setBraking(false);
        boolean needLimit = false;
        for (Racer playerRacer : this.mGameWorld.getPlayerRacers()) {
            if (Racer.compareRaceDistances(this.mRacer, playerRacer) <= 0) continue;
            needLimit = true;
            break;
        }
        float limit = needLimit ? GamePlay.instance.aiSpeedLimiter : 1.0f;
        vehicle.setSpeedLimiter(limit);
    }

    private void updateDirection() {
        Vehicle vehicle;
        float vehicleAngle;
        Target target = this.findBestTarget();
        if (target == null) {
            this.switchToBlocked();
            return;
        }
        float targetAngle = this.mTmpVector1.set(target.position).sub(this.mRacer.getPosition()).angleDeg();
        float deltaAngle = (targetAngle = AgcMathUtils.normalizeAngle(targetAngle)) - (vehicleAngle = (vehicle = this.mRacer.getVehicle()).getAngle());
        if (deltaAngle > 180.0f) {
            deltaAngle -= 360.0f;
        } else if (deltaAngle < -180.0f) {
            deltaAngle += 360.0f;
        }
        float direction = MathUtils.clamp(deltaAngle / (float)GamePlay.instance.lowSpeedMaxSteer, -1.0f, 1.0f);
        vehicle.setDirection(direction);
    }

    private Target findBestTarget() {
        float lapDistance = this.mRacer.getLapPositionComponent().getLapDistance();
        WaypointStore store = this.mTrack.getWaypointStore();
        int index = store.getPreviousIndex(store.getWaypointIndex(lapDistance));
        this.mTarget.reset();
        for (int i = -1; i < 2; ++i) {
            this.mNextTarget.position.set(store.getWaypoint(index));
            this.mNextTarget.score = i;
            this.updateNextTarget();
            if (this.mNextTarget.score > this.mTarget.score) {
                this.mTarget.set(this.mNextTarget.position, this.mNextTarget.score);
            }
            index = store.getNextIndex(index);
        }
        if (this.mTarget.score <= -1.4E-45f) {
            return null;
        }
        return this.mTarget;
    }

    private void updateNextTarget() {
        Vector2 position = this.mTmpVector1;
        Vector2 adjustedTargetPos = this.mTmpVector2;
        position.set(this.mRacer.getPosition()).add(this.mHalfWidth);
        adjustedTargetPos.set(this.mNextTarget.position).add(this.mHalfWidth);
        if (!this.checkClearLine(position, adjustedTargetPos, -2.0f)) {
            this.mNextTarget.reset();
            return;
        }
        position.set(this.mRacer.getPosition()).sub(this.mHalfWidth);
        adjustedTargetPos.set(this.mNextTarget.position).sub(this.mHalfWidth);
        if (!this.checkClearLine(position, adjustedTargetPos, 2.0f)) {
            this.mNextTarget.reset();
            return;
        }
        Material material = this.mMaterialChecker.getSlowestMaterialAhead(this.mRacer.getPosition(), this.mNextTarget.position);
        if (material.isHole()) {
            this.mNextTarget.reset();
            return;
        }
        this.mNextTarget.score += 1.0f * material.getSpeed();
    }

    private boolean checkClearLine(Vector2 position, Vector2 adjustedTargetPos, float avoidanceFactor) {
        World world = this.mGameWorld.getBox2DWorld();
        Body body = this.mClosestBodyFinder.find(world, position, adjustedTargetPos);
        if (body == null) {
            return true;
        }
        if (BodyIdentifier.isWall(body)) {
            return false;
        }
        float dx = 2.0f * this.mHalfWidth.x * avoidanceFactor;
        float dy = 2.0f * this.mHalfWidth.y * avoidanceFactor;
        this.mNextTarget.position.set(body.getPosition()).add(dx, dy);
        return true;
    }

    private void handleBonus(float dt) {
        Bonus bonus = this.mRacer.getBonus();
        if (bonus != null) {
            bonus.aiAct(dt);
        }
    }

    private static enum State {
        NORMAL,
        BLOCKED;

    }

    private static class Target {
        static final float MIN_SCORE = -1.4E-45f;
        static final float NO_OBSTACLES = 1.0f;
        final Vector2 position = new Vector2();
        float score = -1.4E-45f;

        private Target() {
        }

        public void reset() {
            this.score = -1.4E-45f;
        }

        public void set(Vector2 position, float score) {
            this.position.set(position);
            this.score = score;
        }
    }
}

