/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.bonus.BonusPool;
import com.agateau.pixelwheels.bonus.BonusSpot;
import com.agateau.pixelwheels.bonus.GunBonus;
import com.agateau.pixelwheels.bonus.MineBonus;
import com.agateau.pixelwheels.bonus.MissileBonus;
import com.agateau.pixelwheels.bonus.TurboBonus;
import com.agateau.pixelwheels.gameobject.GameObject;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.obstacles.ObstacleCreator;
import com.agateau.pixelwheels.obstacles.ObstacleDef;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleCreator;
import com.agateau.pixelwheels.racer.AIPilot;
import com.agateau.pixelwheels.racer.LapPositionComponent;
import com.agateau.pixelwheels.racer.PlayerPilot;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.racescreen.CountDown;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.pixelwheels.vehicledef.VehicleCreator;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.Assert;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.PerformanceCounter;
import com.badlogic.gdx.utils.PerformanceCounters;
import java.util.Comparator;
import java.util.Scanner;

public class GameWorldImpl
implements ContactListener,
Disposable,
GameWorld {
    private static final Racer.RecordRanks DEBUG_RECORD_RANKS = GameWorldImpl.parseFinishedOverlayDebugScreen();
    private final PwGame mGame;
    private Track mTrack;
    private final CountDown mCountDown;
    private final World mBox2DWorld;
    private float mTimeAccumulator = 0.0f;
    private final Array<BonusPool> mBonusPools = new Array();
    private final Array<Racer> mRacers = new Array();
    private final Array<Racer> mPlayerRacers = new Array();
    private GameWorld.State mState = GameWorld.State.COUNTDOWN;
    private final Array<GameObject> mActiveGameObjects = new Array();
    private final PerformanceCounter mBox2DPerformanceCounter;
    private final PerformanceCounter mGameObjectPerformanceCounter;
    private static final Comparator<Racer> sRacerComparator = (racer1, racer2) -> -Racer.compareRaceDistances(racer1, racer2);

    GameWorldImpl(PwGame game, GameInfo gameInfo, PerformanceCounters performanceCounters) {
        this.mGame = game;
        this.mBox2DWorld = new World(new Vector2(0.0f, 0.0f), true);
        this.mBox2DWorld.setContactListener(this);
        this.mTrack = gameInfo.getTrack();
        this.mTrack.init();
        this.mCountDown = new CountDown(this, game.getAudioManager(), game.getAssets().soundAtlas);
        this.mBox2DPerformanceCounter = performanceCounters.add("- box2d");
        this.mGameObjectPerformanceCounter = performanceCounters.add("- g.o");
        this.setupRacers(gameInfo.getEntrants());
        this.setupObstacles();
        this.setupBonusSpots();
        this.setupBonusPools();
    }

    @Override
    public Track getTrack() {
        return this.mTrack;
    }

    @Override
    public World getBox2DWorld() {
        return this.mBox2DWorld;
    }

    @Override
    public Racer getPlayerRacer(int playerId) {
        return this.mPlayerRacers.get(playerId);
    }

    @Override
    public Array<Racer> getPlayerRacers() {
        return this.mPlayerRacers;
    }

    @Override
    public Array<Racer> getRacers() {
        return this.mRacers;
    }

    @Override
    public Array<BonusPool> getBonusPools() {
        return this.mBonusPools;
    }

    @Override
    public Array<GameObject> getActiveGameObjects() {
        return this.mActiveGameObjects;
    }

    @Override
    public void addGameObject(GameObject object) {
        this.mActiveGameObjects.add(object);
    }

    @Override
    public CountDown getCountDown() {
        return this.mCountDown;
    }

    @Override
    public int getRacerRank(Racer wantedRacer) {
        int rank = 1;
        for (Racer racer : this.mRacers) {
            if (racer == wantedRacer || sRacerComparator.compare(racer, wantedRacer) >= 0) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public float getRacerNormalizedRank(Racer racer) {
        if (this.mRacers.size == 1) {
            return 0.0f;
        }
        return (float)(this.getRacerRank(racer) - 1) / (float)(this.mRacers.size - 1);
    }

    @Override
    public GameStats getGameStats() {
        return this.mGame.getGameStats();
    }

    @Override
    public void act(float delta) {
        float frameTime = Math.min(delta, 0.25f);
        this.mTimeAccumulator += frameTime;
        while (this.mTimeAccumulator >= 0.016666668f) {
            this.mCountDown.act(0.016666668f);
            this.mBox2DPerformanceCounter.start();
            this.mBox2DWorld.step(0.016666668f, 6, 2);
            this.mBox2DPerformanceCounter.stop();
            this.mGameObjectPerformanceCounter.start();
            for (int idx = this.mActiveGameObjects.size - 1; idx >= 0; --idx) {
                GameObject obj = this.mActiveGameObjects.get(idx);
                obj.act(0.016666668f);
                if (!obj.isFinished()) continue;
                this.mActiveGameObjects.removeIndex(idx);
                if (!(obj instanceof Disposable)) continue;
                ((Disposable)((Object)obj)).dispose();
            }
            this.mGameObjectPerformanceCounter.stop();
            this.mTimeAccumulator -= 0.016666668f;
        }
        if (this.haveAllRacersFinished()) {
            this.mRacers.sort(sRacerComparator);
            this.setState(GameWorld.State.FINISHED);
        }
    }

    private boolean haveAllRacersFinished() {
        if (DEBUG_RECORD_RANKS != null && this.mState == GameWorld.State.RUNNING) {
            this.mRacers.shuffle();
            return true;
        }
        for (Racer racer : this.mPlayerRacers) {
            if (racer.getLapPositionComponent().hasFinishedRace()) continue;
            return false;
        }
        return true;
    }

    private void onFinished() {
        TrackStats stats = this.mGame.getGameStats().getTrackStats(this.mGame.getConfig().difficulty, this.mTrack);
        for (int idx = 0; idx < this.mRacers.size; ++idx) {
            Racer racer = this.mRacers.get(idx);
            racer.markRaceFinished();
            GameInfo.Entrant entrant = racer.getEntrant();
            int points = this.mRacers.size - idx;
            entrant.addPoints(points);
            LapPositionComponent lapPositionComponent = racer.getLapPositionComponent();
            if (DEBUG_RECORD_RANKS == null) {
                entrant.addRaceTime(lapPositionComponent.getTotalTime());
                if (!entrant.isPlayer()) continue;
                Racer.RecordRanks ranks = racer.getRecordRanks();
                String vehicleId = racer.getVehicle().getId();
                ranks.lapRecordRank = stats.addResult(TrackStats.ResultType.LAP, vehicleId, lapPositionComponent.getBestLapTime());
                ranks.totalRecordRank = stats.addResult(TrackStats.ResultType.TOTAL, vehicleId, lapPositionComponent.getTotalTime());
                continue;
            }
            float totalTime = 92.621f + (float)(idx + 1) * 33.123f;
            lapPositionComponent.fakeCompletion(totalTime);
            entrant.addRaceTime(totalTime);
            if (!entrant.isPlayer()) continue;
            Racer.RecordRanks ranks = racer.getRecordRanks();
            ranks.lapRecordRank = GameWorldImpl.DEBUG_RECORD_RANKS.lapRecordRank;
            ranks.totalRecordRank = GameWorldImpl.DEBUG_RECORD_RANKS.totalRecordRank;
        }
    }

    private void setupRacers(Array<GameInfo.Entrant> entrants) {
        VehicleCreator creator = new VehicleCreator(this.mGame.getAssets(), this);
        Assets assets = this.mGame.getAssets();
        float startAngle = 90.0f;
        Array<Vector2> positions = this.mTrack.findStartTilePositions();
        positions.reverse();
        int maxDrivingForce = GamePlay.instance.getMaxDrivingForce(this.mGame.getConfig().difficulty);
        AudioManager audioManager = this.mGame.getAudioManager();
        for (int idx = 0; idx < entrants.size; ++idx) {
            Assert.check(idx < positions.size, "Too many entrants (" + idx + "/" + positions.size + ")", new Object[0]);
            GameInfo.Entrant entrant = entrants.get(idx);
            VehicleDef vehicleDef = assets.findVehicleDefById(entrant.getVehicleId());
            Vehicle vehicle = creator.create(vehicleDef, positions.get(idx), 90.0f, maxDrivingForce);
            Racer racer = new Racer(assets, audioManager, this, vehicle, entrant);
            if (entrant.isPlayer()) {
                GameInfo.Player player = (GameInfo.Player)entrant;
                PlayerPilot pilot = new PlayerPilot(assets, this, racer, this.mGame.getConfig(), player.getIndex());
                racer.setPilot(pilot);
                this.mPlayerRacers.add(racer);
            } else {
                racer.setPilot(new AIPilot(this, this.mTrack, racer));
            }
            this.addGameObject(racer);
            this.mRacers.add(racer);
        }
    }

    private void setupObstacles() {
        ObstacleCreator creator = new ObstacleCreator();
        for (ObstacleDef def : this.mGame.getAssets().obstacleDefs) {
            creator.addObstacleDef(def);
        }
        for (MapObject object : this.mTrack.getObstacleObjects()) {
            creator.create(this, this.mGame.getAssets(), object);
        }
        TiledObstacleCreator.createObstacles(this, this.mTrack.getMap());
    }

    private void setupBonusSpots() {
        for (Vector2 pos : this.mTrack.findBonusSpotPositions()) {
            BonusSpot spot = new BonusSpot(this.mGame.getAssets(), this.mGame.getAudioManager(), this, pos.x, pos.y);
            this.addGameObject(spot);
        }
    }

    private static <T extends Bonus> boolean isBonusClassAllowed(Class<T> bonusClass) {
        if (Constants.DEBUG_BONUSES == null) {
            return true;
        }
        String className = bonusClass.getSimpleName();
        for (String name : Constants.DEBUG_BONUSES) {
            if (!className.equals(name)) continue;
            NLog.d("%s: true", className);
            return true;
        }
        NLog.d("%s: false", className);
        return false;
    }

    private void setupBonusPools() {
        if (GameWorldImpl.isBonusClassAllowed(GunBonus.class)) {
            this.addPool(GunBonus.class, new float[]{0.2f, 1.0f, 1.0f});
        }
        if (GameWorldImpl.isBonusClassAllowed(MineBonus.class)) {
            this.addPool(MineBonus.class, new float[]{2.0f, 1.0f, 0.5f, 0.0f});
        }
        if (GameWorldImpl.isBonusClassAllowed(TurboBonus.class)) {
            this.addPool(TurboBonus.class, new float[]{0.0f, 1.0f, 2.0f});
        }
        if (GameWorldImpl.isBonusClassAllowed(MissileBonus.class)) {
            this.addPool(MissileBonus.class, new float[]{0.2f, 1.0f, 1.0f});
        }
    }

    private <T extends Bonus> void addPool(Class<T> bonusClass, float[] counts) {
        BonusPool<T> pool = new BonusPool<T>(bonusClass, this.mGame.getAssets(), this, this.mGame.getAudioManager());
        pool.setCounts(counts);
        this.mBonusPools.add(pool);
    }

    @Override
    public void beginContact(Contact contact) {
        Object userA = contact.getFixtureA().getBody().getUserData();
        Object userB = contact.getFixtureB().getBody().getUserData();
        if (userA instanceof Collidable) {
            ((Collidable)userA).beginContact(contact, contact.getFixtureB());
        }
        if (userB instanceof Collidable) {
            ((Collidable)userB).beginContact(contact, contact.getFixtureA());
        }
    }

    @Override
    public void endContact(Contact contact) {
        Object userA = contact.getFixtureA().getBody().getUserData();
        Object userB = contact.getFixtureB().getBody().getUserData();
        if (userA instanceof Collidable) {
            ((Collidable)userA).endContact(contact, contact.getFixtureB());
        }
        if (userB instanceof Collidable) {
            ((Collidable)userB).endContact(contact, contact.getFixtureA());
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        Object userA = contact.getFixtureA().getBody().getUserData();
        Object userB = contact.getFixtureB().getBody().getUserData();
        if (userA instanceof Collidable) {
            ((Collidable)userA).preSolve(contact, contact.getFixtureB(), oldManifold);
        }
        if (userB instanceof Collidable) {
            ((Collidable)userB).preSolve(contact, contact.getFixtureA(), oldManifold);
        }
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
        Object userA = contact.getFixtureA().getBody().getUserData();
        Object userB = contact.getFixtureB().getBody().getUserData();
        if (userA instanceof Collidable) {
            ((Collidable)userA).postSolve(contact, contact.getFixtureB(), impulse);
        }
        if (userB instanceof Collidable) {
            ((Collidable)userB).postSolve(contact, contact.getFixtureA(), impulse);
        }
    }

    @Override
    public GameWorld.State getState() {
        return this.mState;
    }

    @Override
    public void startRace() {
        Assert.check(this.mState == GameWorld.State.COUNTDOWN, "startRace called while not in countdown state", new Object[0]);
        this.setState(GameWorld.State.RUNNING);
    }

    @Override
    public void setState(GameWorld.State state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        if (this.mState == GameWorld.State.FINISHED) {
            this.onFinished();
        }
    }

    @Override
    public void dispose() {
        if (this.mTrack != null) {
            this.mTrack.dispose();
        }
        for (GameObject gameObject : this.mActiveGameObjects) {
            if (!(gameObject instanceof Disposable)) continue;
            ((Disposable)((Object)gameObject)).dispose();
        }
        this.mActiveGameObjects.clear();
    }

    void forgetTrack() {
        this.mTrack = null;
    }

    public static Racer.RecordRanks parseFinishedOverlayDebugScreen() {
        Scanner scanner = new Scanner(Constants.DEBUG_SCREEN);
        scanner.useDelimiter(":");
        if (!scanner.hasNext()) {
            return null;
        }
        if (!"FinishedOverlay".equals(scanner.next())) {
            return null;
        }
        Racer.RecordRanks ranks = new Racer.RecordRanks();
        if (scanner.hasNextInt()) {
            ranks.lapRecordRank = scanner.nextInt();
            if (scanner.hasNextInt()) {
                ranks.totalRecordRank = scanner.nextInt();
            }
        }
        return ranks;
    }
}

