/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItemGroup;
import com.agateau.ui.menu.SliderMenuItem;
import com.agateau.ui.menu.SwitchMenuItem;
import com.agateau.ui.menu.TabMenuItem;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.agateau.utils.Introspector;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class DebugScreen
extends PwStageScreen {
    private final PwGame mGame;
    private MenuItemGroup mCurrentGroup;
    private Introspector mCurrentIntrospector = null;
    private Menu mMenu;
    private Label mGamePlayModifiedLabel;

    public DebugScreen(PwGame game) {
        super(game.getAssets().ui);
        this.mGame = game;
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                DebugScreen.this.mGame.replaceScreen(new DebugScreen(DebugScreen.this.mGame));
            }
        };
        this.setupUi();
    }

    private void setupUi() {
        UiBuilder builder = new UiBuilder(this.mGame.getAssets().atlas, this.mGame.getAssets().ui.skin);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/debug.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.mGamePlayModifiedLabel = (Label)builder.getActor("gamePlayModifiedLabel");
        this.mCurrentIntrospector = this.mGame.getGamePlayIntrospector();
        this.mCurrentIntrospector.addListener(this::updateGamePlayModifiedLabel);
        this.mMenu = (Menu)builder.getActor("menu");
        TabMenuItem tabMenuItem = new TabMenuItem(this.mMenu);
        this.mMenu.addItem(tabMenuItem);
        this.mCurrentGroup = tabMenuItem.addPage("Race");
        this.addRange("Viewport width", "viewportWidth", 20, 800, 10);
        this.addRange("Racer count", "racerCount", 1, 6);
        this.addRange("Border restitution", "borderRestitution", 1, 50);
        this.addCheckBox("One lap only", "oneLapOnly");
        this.addCheckBox("Free camera\n(move with HJKL keys)", "freeCamera");
        this.mCurrentGroup = tabMenuItem.addPage("Speed");
        this.addRange("Max driving force (Casual)", "easyMaxDrivingForce", 10, 200, 10);
        this.addRange("Max driving force (Pro)", "mediumMaxDrivingForce", 10, 200, 10);
        this.addRange("Max driving force (Legen.)", "hardMaxDrivingForce", 10, 200, 10);
        this.addRange("Max speed", "maxSpeed", 10, 400, 10);
        this.addRange("AI speed limiter", "aiSpeedLimiter", 0.1f, 1.0f, 0.1f);
        this.mCurrentGroup = tabMenuItem.addPage("Turbo");
        this.addRange("Strength", "turboStrength", 10, 800, 10);
        this.addRange("Duration", "turboDuration", 0.1f, 2.0f);
        this.mCurrentGroup = tabMenuItem.addPage("Vehicle");
        this.addRange("Wheel stickiness", "maxLateralImpulse", 1, 40);
        this.addRange("Steer: low speed", "lowSpeedMaxSteer", 2, 50, 2);
        this.addRange("Steer: high speed", "highSpeedMaxSteer", 2, 50, 1);
        this.addRange("Vehicle density", "vehicleDensity", 1, 50);
        this.addRange("Tire density", "tireBaseDensity", 1, 50);
        this.addRange("Restitution", "vehicleRestitution", 1, 50);
        this.mCurrentIntrospector = this.mGame.getSoundSettingsIntrospector();
        this.mCurrentGroup = tabMenuItem.addPage("Sound");
        this.addRange("Drift volume", "driftVolume", 0.0f, 1.0f);
        this.addRange("Turbo volume", "turboVolume", 0.0f, 1.0f);
        this.addRange("Engine volume", "engineVolume", 0.0f, 1.0f);
        this.mCurrentIntrospector = this.mGame.getDebugIntrospector();
        this.mCurrentGroup = tabMenuItem.addPage("Misc");
        this.addRange("Max skidmarks", "maxSkidmarks", 10, 200, 10);
        this.addCheckBox("Force touch input", "alwaysShowTouchInput");
        this.addCheckBox("Refresh assets on restart", "refreshAssetsOnRestart");
        this.addCheckBox("Create speed report", "createSpeedReport");
        this.mCurrentGroup = tabMenuItem.addPage("Debug");
        this.addCheckBox("Show debug hud", "showDebugHud");
        this.addCheckBox("Show debug layer", "showDebugLayer");
        this.addCheckBox("- Draw velocities", "drawVelocities");
        this.addCheckBox("- Draw tile corners", "drawTileCorners");
        this.addCheckBox("Hud debug lines", "showHudDebugLines");
        this.addCheckBox("Log UI activities", "logUiActivities");
        this.mMenu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                DebugScreen.this.onBackPressed();
            }
        });
        this.updateGamePlayModifiedLabel();
    }

    private void addTitle(String text) {
        this.mCurrentGroup.addTitleLabel(text);
    }

    private void addCheckBox(String text, final String keyName) {
        final Introspector introspector = this.mCurrentIntrospector;
        final DebugSwitchMenuItem item = new DebugSwitchMenuItem(this.mMenu, keyName, introspector);
        boolean checked = (Boolean)introspector.get(keyName);
        item.setChecked(checked);
        this.mCurrentGroup.addItemWithLabel(text, item);
        item.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean value = item.isChecked();
                introspector.set(keyName, value);
            }
        });
    }

    private void addRange(String text, String keyName, int min, int max) {
        this.addRange(text, keyName, min, max, 1);
    }

    private void addRange(String text, final String keyName, int min, int max, int stepSize) {
        final Introspector introspector = this.mCurrentIntrospector;
        final DebugIntSliderMenuItem item = new DebugIntSliderMenuItem(this.mMenu, keyName, introspector);
        item.setRange(min, max, stepSize);
        item.setIntValue(introspector.getInt(keyName));
        item.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int value = item.getIntValue();
                introspector.setInt(keyName, value);
                item.updateMainActor();
            }
        });
        this.mCurrentGroup.addItemWithLabel(text, item);
    }

    private void addRange(String text, String keyName, float min, float max) {
        this.addRange(text, keyName, min, max, 0.1f);
    }

    private void addRange(String text, final String keyName, float min, float max, float stepSize) {
        final Introspector introspector = this.mCurrentIntrospector;
        final DebugFloatSliderMenuItem item = new DebugFloatSliderMenuItem(this.mMenu, keyName, introspector);
        item.setRange(min, max, stepSize);
        item.setFloatValue(introspector.getFloat(keyName));
        item.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                float value = item.getFloatValue();
                introspector.setFloat(keyName, value);
                item.updateMainActor();
            }
        });
        this.mCurrentGroup.addItemWithLabel(text, item);
    }

    @Override
    public void onBackPressed() {
        this.mGame.getDebugIntrospector().save();
        this.mGame.getGamePlayIntrospector().save();
        this.mGame.popScreen();
    }

    private void updateGamePlayModifiedLabel() {
        this.mGamePlayModifiedLabel.setVisible(this.mGame.getGamePlayIntrospector().hasBeenModified());
    }

    private static class DebugSwitchMenuItem
    extends SwitchMenuItem {
        private final String mKeyName;
        private final Introspector mIntrospector;

        public DebugSwitchMenuItem(Menu menu, String keyName, Introspector introspector) {
            super(menu);
            this.mKeyName = keyName;
            this.mIntrospector = introspector;
        }

        @Override
        protected String formatValue(boolean value) {
            boolean current;
            String text = super.formatValue(value);
            boolean ref = (Boolean)this.mIntrospector.getReference(this.mKeyName);
            if (ref != (current = ((Boolean)this.mIntrospector.get(this.mKeyName)).booleanValue()) && value == ref) {
                text = text + "*";
            }
            return text;
        }
    }

    private static class DebugIntSliderMenuItem
    extends SliderMenuItem {
        private final String mKeyName;
        private final Introspector mIntrospector;

        public DebugIntSliderMenuItem(Menu menu, String keyName, Introspector introspector) {
            super(menu);
            this.mKeyName = keyName;
            this.mIntrospector = introspector;
        }

        @Override
        protected String formatValue(int value) {
            int current;
            String text = super.formatValue(value);
            int ref = (Integer)this.mIntrospector.getReference(this.mKeyName);
            if (ref != (current = ((Integer)this.mIntrospector.get(this.mKeyName)).intValue())) {
                text = text + " (" + super.formatValue(ref) + ")";
            }
            return text;
        }
    }

    private static class DebugFloatSliderMenuItem
    extends SliderMenuItem {
        private final String mKeyName;
        private final Introspector mIntrospector;

        public DebugFloatSliderMenuItem(Menu menu, String keyName, Introspector introspector) {
            super(menu);
            this.mKeyName = keyName;
            this.mIntrospector = introspector;
        }

        @Override
        protected String formatValue(int value) {
            float current;
            String text = super.formatValue(value);
            float ref = ((Float)this.mIntrospector.getReference(this.mKeyName)).floatValue();
            if (ref != (current = ((Float)this.mIntrospector.get(this.mKeyName)).floatValue())) {
                int intValue = (int)(ref * this.getDivisor());
                text = text + " (" + super.formatValue(intValue) + ")";
            }
            return text;
        }
    }
}

