/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.utils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;

public class ClosestBodyFinder {
    private final BodyFilter mFilter;
    private final StaticBodyRayCastCallback mRayCastCallback = new StaticBodyRayCastCallback();

    public ClosestBodyFinder() {
        this(null);
    }

    public ClosestBodyFinder(BodyFilter filter) {
        this.mFilter = filter;
    }

    public Body find(World world, Vector2 point1, Vector2 point2) {
        this.mRayCastCallback.mBody = null;
        world.rayCast(this.mRayCastCallback, point1, point2);
        return this.mRayCastCallback.mBody;
    }

    public static interface BodyFilter {
        public boolean acceptBody(Body var1);
    }

    private class StaticBodyRayCastCallback
    implements RayCastCallback {
        Body mBody = null;

        private StaticBodyRayCastCallback() {
        }

        @Override
        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            Body body = fixture.getBody();
            if (ClosestBodyFinder.this.mFilter == null || ClosestBodyFinder.this.mFilter.acceptBody(body)) {
                this.mBody = body;
                return 0.0f;
            }
            return -1.0f;
        }
    }
}

