/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.utils.log.NLog;

public class DimensionParser {
    public float gridSize = 1.0f;

    public float parse(String txt) {
        return this.parse(txt, Unit.PIXEL);
    }

    public float parse(String txt, Unit defaultUnit) {
        if (txt.equals("0")) {
            return 0.0f;
        }
        if (txt.endsWith("px")) {
            return Float.parseFloat(txt.substring(0, txt.length() - 2));
        }
        if (txt.endsWith("g")) {
            return Float.parseFloat(txt.substring(0, txt.length() - 1)) * this.gridSize;
        }
        float k = defaultUnit == Unit.PIXEL ? 1.0f : this.gridSize;
        try {
            return Float.parseFloat(txt) * k;
        }
        catch (NumberFormatException exc) {
            NLog.e("Invalid dimension text: " + txt, new Object[0]);
            return 12.0f;
        }
    }

    public static enum Unit {
        GRID,
        PIXEL;

    }
}

