/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;

public abstract class RefreshHelper {
    public RefreshHelper(Stage stage) {
        this.installEventListener(stage);
    }

    public RefreshHelper(Group group) {
        Actor helperActor = new Actor(){

            @Override
            public void setStage(Stage stage) {
                super.setStage(stage);
                RefreshHelper.this.installEventListener(stage);
            }
        };
        group.addActor(helperActor);
    }

    private void installEventListener(Stage stage) {
        if (stage == null) {
            return;
        }
        stage.addListener(new InputListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 135) {
                    NLog.i("Refreshing", new Object[0]);
                    Gdx.app.postRunnable(() -> {
                        try {
                            RefreshHelper.this.refreshAssets();
                            RefreshHelper.this.refresh();
                        }
                        catch (Exception exc) {
                            NLog.e("Refresh failed: %s", exc);
                        }
                    });
                    return true;
                }
                return false;
            }
        });
    }

    protected void refreshAssets() {
    }

    protected abstract void refresh();
}

