/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.anchor;

import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorRule;
import com.agateau.ui.anchor.PositionRule;
import com.agateau.ui.anchor.SizeRule;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import java.util.Iterator;

public class AnchorGroup
extends WidgetGroup {
    private float mGridSize = 1.0f;
    private final Array<AnchorRule> mRules = new Array();

    public void setGridSize(float gridSize) {
        this.mGridSize = gridSize;
    }

    public float getGridSize() {
        return this.mGridSize;
    }

    public void addPositionRule(Actor target, Anchor targetAnchor, Actor reference, Anchor referenceAnchor) {
        this.addPositionRule(target, targetAnchor, reference, referenceAnchor, 0.0f, 0.0f);
    }

    public void addPositionRule(Actor target, Anchor targetAnchor, Actor reference, Anchor referenceAnchor, float hSpace, float vSpace) {
        PositionRule rule = new PositionRule();
        rule.target = target;
        rule.targetAnchor = targetAnchor;
        rule.reference = reference;
        rule.referenceAnchor = referenceAnchor;
        rule.hSpace = hSpace * this.mGridSize;
        rule.vSpace = vSpace * this.mGridSize;
        this.addRule(rule);
    }

    public void addSizeRule(Actor target, Actor reference, float hPercent, float vPercent) {
        this.addSizeRule(target, reference, hPercent, vPercent, 0.0f, 0.0f);
    }

    public void addSizeRule(Actor target, Actor reference, float hPercent, float vPercent, float hSpace, float vSpace) {
        SizeRule rule = new SizeRule(target, reference, hPercent, vPercent);
        rule.setPadding(hSpace * this.mGridSize, vSpace * this.mGridSize);
        this.addRule(rule);
    }

    public void addRule(AnchorRule rule) {
        this.mRules.add(rule);
        Actor target = rule.getTarget();
        if (target.getParent() == null) {
            this.addActor(target);
        }
    }

    public void removeRulesForActor(Actor actor) {
        Iterator it = this.mRules.iterator();
        while (it.hasNext()) {
            AnchorRule rule = (AnchorRule)it.next();
            if (rule.getTarget() != actor) continue;
            it.remove();
        }
    }

    @Override
    public void layout() {
        for (Actor actor : this.getChildren()) {
            if (!(actor instanceof Layout)) continue;
            ((Layout)((Object)actor)).invalidate();
            ((Layout)((Object)actor)).validate();
        }
        for (AnchorRule rule : this.mRules) {
            rule.apply();
        }
    }

    @Override
    public float getPrefWidth() {
        return this.getWidth();
    }

    @Override
    public float getPrefHeight() {
        return this.getHeight();
    }
}

