/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.Scene2dUtils;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.anchor.EdgeRule;
import com.agateau.ui.menu.FocusIndicator;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

abstract class RangeMenuItem
extends AnchorGroup
implements MenuItem {
    private final Menu mMenu;
    private final Button mLeftButton;
    private final Button mRightButton;
    private final Rectangle mRect = new Rectangle();
    private final FocusIndicator mFocusIndicator;
    private final RangeMenuItemStyle mStyle;
    private Actor mMainActor;

    public RangeMenuItem(Menu menu) {
        this.mMenu = menu;
        this.mFocusIndicator = new FocusIndicator(menu);
        this.mStyle = menu.getSkin().get(RangeMenuItemStyle.class);
        this.mLeftButton = RangeMenuItem.createButton(this.mStyle.decIcon, menu.getSkin());
        this.mLeftButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RangeMenuItem.this.decrease();
                RangeMenuItem.this.fireChangeEvent();
            }
        });
        this.mRightButton = RangeMenuItem.createButton(this.mStyle.incIcon, menu.getSkin());
        this.mRightButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RangeMenuItem.this.increase();
                RangeMenuItem.this.fireChangeEvent();
            }
        });
        this.setHeight(this.mLeftButton.getPrefHeight());
        this.addAction(Actions.run(this::postConstructorSetup));
    }

    protected void fireChangeEvent() {
        Scene2dUtils.fireChangeEvent(this);
    }

    private void postConstructorSetup() {
        this.mMainActor = this.createMainActor(this.mMenu);
        float padding = this.mStyle.framePadding;
        float buttonSize = this.getHeight() - 2.0f * padding;
        this.addPositionRule(this.mLeftButton, Anchor.TOP_LEFT, this, Anchor.TOP_LEFT, padding, -padding);
        this.addPositionRule(this.mRightButton, Anchor.TOP_RIGHT, this, Anchor.TOP_RIGHT, -padding, -padding);
        this.mLeftButton.setSize(buttonSize, buttonSize);
        this.mRightButton.setSize(buttonSize, buttonSize);
        this.addPositionRule(this.mMainActor, Anchor.TOP_LEFT, this.mLeftButton, Anchor.TOP_RIGHT);
        this.addRule(new EdgeRule(this.mMainActor, EdgeRule.Edge.RIGHT, this.mRightButton, EdgeRule.Edge.LEFT));
        this.addRule(new EdgeRule(this.mMainActor, EdgeRule.Edge.BOTTOM, this.mRightButton, EdgeRule.Edge.BOTTOM));
        this.updateMainActor();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.mFocusIndicator.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.mFocusIndicator.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.mStyle.frame.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }

    protected abstract Actor createMainActor(Menu var1);

    public abstract void updateMainActor();

    protected abstract void decrease();

    protected abstract void increase();

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setFocused(boolean focused) {
        this.mFocusIndicator.setFocused(focused);
    }

    @Override
    public Actor getActor() {
        return this;
    }

    @Override
    public void trigger() {
    }

    @Override
    public boolean goUp() {
        return false;
    }

    @Override
    public boolean goDown() {
        return false;
    }

    @Override
    public void goLeft() {
        Scene2dUtils.simulateClick(this.mLeftButton);
    }

    @Override
    public void goRight() {
        Scene2dUtils.simulateClick(this.mRightButton);
    }

    @Override
    public Rectangle getFocusRectangle() {
        this.mRect.x = 0.0f;
        this.mRect.y = 0.0f;
        this.mRect.width = this.getWidth();
        this.mRect.height = this.getHeight();
        return this.mRect;
    }

    @Override
    public float getParentWidthRatio() {
        return 1.0f;
    }

    private static Button createButton(Drawable drawable, Skin skin) {
        ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle(skin.get(ImageButton.ImageButtonStyle.class));
        style.imageUp = drawable;
        return new ImageButton(style);
    }

    public static class RangeMenuItemStyle {
        Drawable frame;
        float framePadding;
        Drawable incIcon;
        Drawable decIcon;
    }
}

