/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class KeyValueWriter {
    private final Writer mWriter;
    private boolean mFirstValue = true;

    public KeyValueWriter(FileHandle handle) {
        this.mWriter = handle.writer(false);
    }

    public void put(String key, Object value) {
        try {
            if (this.mFirstValue) {
                this.mWriter.append('{');
                this.mFirstValue = false;
            } else {
                this.mWriter.append(',');
            }
            this.mWriter.append('\"');
            this.mWriter.append(key);
            this.mWriter.append("\":");
            if (value instanceof Float) {
                String text = String.format(Locale.US, "%f", (Float)value);
                this.mWriter.append(text);
            } else if (value instanceof Integer) {
                String text = String.format(Locale.US, "%d", (Integer)value);
                this.mWriter.append(text);
            } else if (value instanceof Boolean) {
                String text = (Boolean)value != false ? "true" : "false";
                this.mWriter.append(text);
            } else {
                String text = value.toString().replace("\"", "\\\"");
                this.mWriter.append('\"');
                this.mWriter.append(text);
                this.mWriter.append('\"');
            }
        }
        catch (IOException e) {
            NLog.e("Failed to write KV file", new Object[0]);
            e.printStackTrace();
        }
    }

    public void endRow() {
        try {
            this.mWriter.append("}\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            NLog.e("Failed to write KV file", new Object[0]);
            e.printStackTrace();
        }
        this.mFirstValue = true;
    }
}

